/*
 * Generated by XCodeGen v1.0
 * Sun Jul 07 16:05:42 EDT 2002
 */

package xcodegen.sample.domain.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Types;
import xcodegen.sample.domain.dto.PersonDTO;

/**
 * Person
 *
 * @author Herve Tchepannou
 * @version 
 *
 * @see PersonDTO
 */
public class PersonDAO
{
    /** INSERT SQL statement */
    public static final String SQL_INSERT = "INSERT INTO PERSON(id,firstname,lastname,email) VALUES(?,?,?,?)";
    
    /** SELECT SQL statement */
    public static final String SQL_SELECT = "SELECT PERSON.id,PERSON.firstname,PERSON.lastname,PERSON.email FROM PERSON";
    
    /** UPDATE SQL statement */
    public static final String SQL_UPDATE = "UPDATE PERSON SET firstname=?,lastname=?,email=?";
    
    /** Delete SQL Statement */
    public static final String SQL_DELETE = "DELETE FROM PERSON";

    /** Active connection */
    private Connection cnn;
    
    
////////////////////////////////////
// Constructors
////////////////////////////////////

    public PersonDAO( Connection cnn )
    {
        if ( cnn == null )  throw new IllegalArgumentException( "cnn is null" );
        
        this.cnn = cnn;
    }
    

////////////////////////////////////
// Public methods
////////////////////////////////////
    
    /**
     * Persist a Person into the database
     *
     * @param       Person to persist
     * @return      value of the primary key of the object persisted
     * @throws      SQLException if any error occurs
     */
    public int create( PersonDTO data ) throws SQLException
    {
        PreparedStatement stmt = null;
        try
        {

            // Create the object
            stmt = cnn.prepareStatement( SQL_INSERT, ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY );
            
                            
        stmt.setInt( 1, data.getId() );
                                
        stmt.setString( 2, data.getFirstname() );
                                
        stmt.setString( 3, data.getLastname() );
                                
        stmt.setString( 4, data.getEmail() );
    
            stmt.executeUpdate();
            
            return data.getId();
        }
        finally
        {
            if ( stmt != null )
            {
                try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
        }
    }

    /**
     * Persist modification on a Person into the database
     *
     * @param       Person to persist
     * @throws      SQLException if any error occurs
     */
    public void update( PersonDTO data ) throws SQLException
    {

        // Update the object
        PreparedStatement stmt = null;
        try
        {
            stmt = cnn.prepareStatement( SQL_UPDATE + " WHERE id=?", ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY );

                
                                
        stmt.setString( 1, data.getFirstname() );
                
                                
        stmt.setString( 2, data.getLastname() );
                
                                
        stmt.setString( 3, data.getEmail() );
                                        
        stmt.setInt( 4, data.getId() );
    
            stmt.executeUpdate();
        }
        finally
        {
            if ( stmt != null )
            {
                try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
        }
    }


    /**
     * Remove a Person from the database
     *
     * @param       pk  Primary key of the Person to remove
     * @throws      SQLException if any error occurs
     */
    public void removeByPK( int pk ) throws SQLException
    {
        PreparedStatement stmt = null;
        try
        {

            // Remove the object
            stmt = cnn.prepareStatement( SQL_DELETE + " WHERE id=?", ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY );
            
                                
        stmt.setInt( 1, pk );
                
            stmt.executeUpdate();
        }
        finally
        {
            if ( stmt != null )
            {
                try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
        }
    }



    /**
     * Find a Person by its primary key
     *
     * @param pk    primary key of the Person requested
     * @return      Person found, <code>null</code> if nothing found
     * @throws      SQLException if any error occurs
     */
    public PersonDTO findByPK( int pk ) throws SQLException
    {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try
        {
            String sql = SQL_SELECT + " WHERE PERSON.id=?";
            stmt = cnn.prepareStatement( sql, ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY );
                
                                
        stmt.setInt( 1, pk );
    
            rs = stmt.executeQuery();
            return rs.next() ? newDataObject( rs ) : null;
        }
        finally
        {
            if ( rs != null )
            {
                try{    rs.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
            if ( stmt != null )
            {
                try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
        }
    }

 

//////////////////////////////////////////////////
// Private methods
//////////////////////////////////////////////////

    private Collection filter( ResultSet rs, int offset, int maxcount ) throws SQLException
    {
        Collection col = new ArrayList();
        for( int i=0, count=0 ; rs.next() && ( maxcount > count ) ; i++ )
        {
            if ( i >= offset )
            {
                col.add( newDataObject( rs ) );
                count++;
            }
        }
        return col;
    }

    private PersonDTO newDataObject( ResultSet rs ) throws SQLException
    {
        PersonDTO data = new PersonDTO();
        

                        data.setId( rs.getInt( 1 ) );

                        data.setFirstname( rs.getString( 2 ) );

                        data.setLastname( rs.getString( 3 ) );

                        data.setEmail( rs.getString( 4 ) );

        return data;
    }
}
