/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DTDLocation;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLCatalog
extends DataType
implements Cloneable,
EntityResolver {
    private FileUtils fileUtils = FileUtils.newFileUtils();
    private Vector elements = new Vector();
    private Path classpath;

    private Vector getElements() {
        return this.elements;
    }

    private Path getClasspath() {
        return this.classpath;
    }

    private void setElements(Vector aVector) {
        this.elements = aVector;
    }

    private void addElement(DTDLocation aDTD) {
        this.getElements().addElement(aDTD);
    }

    public Path createClasspath() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspath(Path classpath) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public void setClasspathRef(Reference r) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createClasspath().setRefid(r);
    }

    public void addDTD(DTDLocation dtd) throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.getElements().addElement(dtd);
    }

    public void addEntity(DTDLocation dtd) throws BuildException {
        this.addDTD(dtd);
    }

    public void addConfiguredXMLCatalog(XMLCatalog catalog) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        Vector newElements = catalog.getElements();
        Vector ourElements = this.getElements();
        Enumeration enumeration = newElements.elements();
        while (enumeration.hasMoreElements()) {
            ourElements.addElement(enumeration.nextElement());
        }
        Path nestedClasspath = catalog.getClasspath();
        this.createClasspath().append(nestedClasspath);
    }

    public void setRefid(Reference r) throws BuildException {
        if (!this.elements.isEmpty()) {
            throw this.tooManyAttributes();
        }
        Object o = r.getReferencedObject(this.getProject());
        if (!(o instanceof XMLCatalog)) {
            String msg = r.getRefId() + " does not refer to an XMLCatalog";
            throw new BuildException(msg);
        }
        XMLCatalog catalog = (XMLCatalog)o;
        this.setElements(catalog.getElements());
        super.setRefid(r);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource source;
        block9: {
            source = null;
            DTDLocation matchingDTD = this.findMatchingDTD(publicId);
            if (matchingDTD != null) {
                this.log("Matching DTD found for publicId: '" + publicId + "' location: '" + matchingDTD.getLocation() + "'", 4);
                File dtdFile = this.project.resolveFile(matchingDTD.getLocation());
                if (dtdFile.exists() && dtdFile.canRead()) {
                    source = new InputSource(new FileInputStream(dtdFile));
                    URL dtdFileURL = this.fileUtils.getFileURL(dtdFile);
                    source.setSystemId(dtdFileURL.toExternalForm());
                    this.log("matched a readable file", 4);
                } else {
                    AntClassLoader loader = null;
                    loader = this.classpath != null ? new AntClassLoader(this.project, this.classpath) : new AntClassLoader(this.project, Path.systemClasspath);
                    InputStream is = loader.getResourceAsStream(matchingDTD.getLocation());
                    if (is != null) {
                        source = new InputSource(is);
                        source.setSystemId(loader.getResource(matchingDTD.getLocation()).toExternalForm());
                        this.log("matched a resource", 4);
                    } else {
                        try {
                            URL dtdUrl = new URL(matchingDTD.getLocation());
                            InputStream dtdIs = dtdUrl.openStream();
                            if (dtdIs != null) {
                                source = new InputSource(dtdIs);
                                source.setSystemId(dtdUrl.toExternalForm());
                                this.log("matched as a URL", 4);
                                break block9;
                            }
                            this.log("No match, parser will use: '" + systemId + "'", 4);
                        }
                        catch (IOException ioe) {}
                    }
                }
            } else {
                this.log("No match, parser will use: '" + systemId + "'", 4);
            }
        }
        return source;
    }

    private DTDLocation findMatchingDTD(String publicId) {
        Enumeration elements = this.getElements().elements();
        DTDLocation element = null;
        while (elements.hasMoreElements()) {
            element = (DTDLocation)elements.nextElement();
            if (!element.getPublicId().equals(publicId)) continue;
            return element;
        }
        return null;
    }
}

