#ifndef _PROFILE_H_INCLUDED
#define	_PROFILE_H_INCLUDED
//------------------------------------------------------------------------------
// The root key location
#define	SUBKEY			"Software\\WinMaster"
#define	VAL_DEFPROFILE	"DefProfile"
#define	VAL_COMMAND		"command"
#define VAL_PRERUN		"prerun"
#define	VAL_KILL		"kill"
#define	VAL_PIDFILE		"pidfile"
#define VAL_BINDIR		"bindir"
#define VAL_TITLE		"title"
#define	VAL_READY 		"ready"
#define	VAL_SHUTDOWN	"shutdown"
#define VAL_STOPQUIT	"stopquit"
#define	VAL_LOGFILE		"logfile"
#define VAL_LOGOUT		"logout"
//------------------------------------------------------------------------------
class ProfileReader
{
public:
	ProfileReader(char *path=NULL);
	~ProfileReader();

	void	SetProfile(char *profile);
	int		OpenKey( HKEY hKey = HKEY_LOCAL_MACHINE, LPCTSTR lpSubKey = SUBKEY );
	int		ReadValue( LPTSTR lpValueName, LPSTR lpszReturn, DWORD cb);
	BOOL	ReadBoolValue(LPTSTR lpValueName, BOOL def);
	int		ReadValues( void );
	int		SetValue( LPTSTR lpValueName, LPTSTR lpValue );
	int		SetValues( void );
	void	Log(char *buf);

	char	m_subkey[MAX_BUF_LEN];
	char	m_command[MAX_BUF_LEN];
	char	m_prerun[MAX_BUF_LEN];
	char	m_kill[MAX_BUF_LEN];
	char	m_pidfile[MAX_BUF_LEN];
	char	m_bindir[MAX_BUF_LEN];
	char	m_title[MAX_BUF_LEN];
	char	m_ready[MAX_BUF_LEN];	
	char	m_shutdown[MAX_BUF_LEN];	
	char	m_logfile[MAX_BUF_LEN];
	BOOL	m_stopquit;
	BOOL	m_logout;
	FILE *	m_outputFile;

private:
	HKEY	MyKey;
	BYTE 	lpData[MAX_BUF_LEN];
};
//------------------------------------------------------------------------------
extern "C" int ProfileRead( char *profile );
//------------------------------------------------------------------------------
#endif	// ifndef _PROFILE_H_INCLUDED
