/* Processed by ecpg (3.1.0) */
/* These include files are added by the preprocessor */
#include <ecpgtype.h>
#include <ecpglib.h>
#include <ecpgerrno.h>
#include <sqlca.h>
#line 1 "sqlwrite.ec"
/* End of automatic include section */
#include <arpa/inet.h>
#include <net/ethernet.h>
#include <netdb.h>
#include <netinet/ether.h>
#include <netinet/if_ether.h>
#include <netinet/ip.h>
#include <pthread.h>
#include <sys/time.h>
#include <unistd.h>
#include <pcap.h>
#include <syslog.h>

#include <unistd.h>
#include <stdio.h>
#include <getopt.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>
#include <iostream>

#include <list>
#include <map>
#include <string>

using namespace std;


#include "ip.h"
#include "dns.h"
#include "prio.h"
#include "monlist.h"


#line 1 "/usr/local/postgres/include/sqlca.h"
#ifndef POSTGRES_SQLCA_H
#define POSTGRES_SQLCA_H

#ifndef DLLIMPORT
#if defined(__CYGWIN__) || defined(WIN32)
#define DLLIMPORT __declspec (dllimport)
#else
#define DLLIMPORT
#endif   /* __CYGWIN__ */
#endif   /* DLLIMPORT */

#define SQLERRMC_LEN	70

#ifdef __cplusplus
extern		"C"
{
#endif

struct sqlca_t
{
	char		sqlcaid[8];
	long		sqlabc;
	long		sqlcode;
	struct
	{
		int			sqlerrml;
		char		sqlerrmc[SQLERRMC_LEN];
	}			sqlerrm;
	char		sqlerrp[8];
	long		sqlerrd[6];
	/* Element 0: empty						*/
	/* 1: OID of processed tuple if applicable			*/
	/* 2: number of rows processed				*/
	/* after an INSERT, UPDATE or				*/
	/* DELETE statement					*/
	/* 3: empty						*/
	/* 4: empty						*/
	/* 5: empty						*/
	char		sqlwarn[8];
	/* Element 0: set to 'W' if at least one other is 'W'	*/
	/* 1: if 'W' at least one character string		*/
	/* value was truncated when it was			*/
	/* stored into a host variable.				*/

	/*
	 * 2: if 'W' a (hopefully) non-fatal notice occurred
	 */	/* 3: empty */
	/* 4: empty						*/
	/* 5: empty						*/
	/* 6: empty						*/
	/* 7: empty						*/

	char		sqlstate[5];
};

struct sqlca_t *ECPGget_sqlca(void);

#ifndef POSTGRES_ECPG_INTERNAL
#define sqlca (*ECPGget_sqlca())
#endif

#ifdef __cplusplus
}
#endif

#endif

#line 33 "sqlwrite.ec"


void	SQLConnect(char *connectionInfo)
{
	/* exec sql begin declare section */
		
	
#line 38 "sqlwrite.ec"
 char * connection   ;
/* exec sql end declare section */
#line 39 "sqlwrite.ec"


	connection = connectionInfo;

	{ ECPGconnect(__LINE__, 0, connection , NULL,NULL , NULL, 0); }
#line 43 "sqlwrite.ec"

	if(sqlca.sqlcode) {
		cerr << "connect Error # " << sqlca.sqlerrm.sqlerrml << " '" << sqlca.sqlerrm.sqlerrmc << "'" << endl;
		exit(0);
	}
}

static void timevalToDate(const struct timeval *in, char *out)
{
   struct tm *ti = localtime(&in->tv_sec);
	sprintf(out, "%04d-%02d-%02d %02d:%02d:%02d.%d", 
			ti->tm_year + 1900, ti->tm_mon + 1, ti->tm_mday,
			ti->tm_hour, ti->tm_min, ti->tm_sec,
			in->tv_usec);
}
static int SizeIfExpanded(int count, const unsigned char *in, char *out)
{
	int	ii;
	int	size = 0;

	for (ii = 0; ii < count; ii++, in++) {
		switch (*in) {
		case 0:
			size += 5;
			if (out) {
				*out++ = '\\';
				*out++ = '\\';
				*out++ = '0';
				*out++ = '0';
				*out++ = '0';
			}
			break;
		case '\'':
			size += 2;
			if (out) {
				*out++ = '\\';
				*out++ = '\'';
			}
			break;
		case '\\':
			size += 4;
			if (out) {
				*out++ = '\\';
				*out++ = '\\';
				*out++ = '\\';
				*out++ = '\\';
			}
			break;
		default:
			size++;
			if (out) {
				*out++= *in;
			}
			break;
		}
	}
	return size;
}

static char	*ToPsqlBinaryString(CDataBlockList& dbl)
{
	int	totalSize = 0;
	int	chunks = 0;
	// cout << "segment" << endl;
	for (CDataBlockListIter iter = dbl.begin(); iter != dbl.end(); iter++, chunks++) {
      	int segSize = SizeIfExpanded((*iter)->size_m, (*iter)->data_m, 0);
		// cout << "\tsegment size " << segSize << " in " << chunks << endl;
		totalSize += segSize;
	}
	// cout << "\t\ttotal" << totalSize << endl;
	return "crapola";
}

bool	SQlSaveRecord(CRecord *cr, string interfaceName)
{
	struct in_addr kk;
	/* exec sql begin declare section */
		
		
		
	 	
		
	 	
		
		
		
		
	  
	 		
			
		
	
#line 120 "sqlwrite.ec"
 int  f_src_ip_serial   ;
 
#line 121 "sqlwrite.ec"
 int  f_dst_ip_serial   ;
 
#line 122 "sqlwrite.ec"
 int  f_port_src   ;
 
#line 123 "sqlwrite.ec"
 int  f_port_dst   ;
 
#line 124 "sqlwrite.ec"
 int  f_protocol_number   ;
 
#line 125 "sqlwrite.ec"
 int  f_volume   ;
 
#line 126 "sqlwrite.ec"
 int  f_packets   ;
 
#line 127 "sqlwrite.ec"
 int  f_flushed   ;
 
#line 128 "sqlwrite.ec"
 int  ind_flushed   ;
 
#line 129 "sqlwrite.ec"
 char  f_lastUpdate [ 30 ]   ;
 
#line 130 "sqlwrite.ec"
 char  f_firstUpdate [ 30 ]   ;
 
#line 131 "sqlwrite.ec"
 const char * f_interface   ;
 
#line 132 "sqlwrite.ec"
 int  ind_contents   ;
 
#line 133 "sqlwrite.ec"
 char * f_contents   ;
/* exec sql end declare section */
#line 134 "sqlwrite.ec"


	f_port_src = cr->port_src_m;
	f_src_ip_serial = cr->srcSerial_m;
	f_port_dst = cr->port_dst_m;
	f_dst_ip_serial = cr->dstSerial_m;
	f_protocol_number = cr->ip_proto_m;
	f_volume = cr->volume_m;
	f_packets = cr->packets_m;
	if (cr->flushed_m) {
		f_flushed = cr->flushed_m;
		ind_flushed = 0;
	} else
		ind_flushed = -1;
	timevalToDate(&cr->lastUpdate_, f_lastUpdate);
	timevalToDate(&cr->firstUpdate_, f_firstUpdate);
	f_interface = interfaceName.c_str();
	if (cr->dataBlockList_m.size()) {
		ind_contents = 1;
		f_contents = ToPsqlBinaryString(cr->dataBlockList_m);
	} else {
		ind_contents = -1;
	}

	{ ECPGtrans(__LINE__, NULL, "begin transaction");}
#line 158 "sqlwrite.ec"

	/* contents) */{ ECPGdo(__LINE__, 0, 1, NULL, "insert into usage ( src_ip_serial  , dst_ip_serial  , port_src  , port_dst  , protocol_number  , first_seen  , last_seen  , packets  , volume  , interface  , flushed  ) values (  ? ,  ? ,  ? ,  ? ,  ? ,  ? ,  ? ,  ? ,  ? ,  ? ,  ? )", 
	ECPGt_int,&(f_src_ip_serial),(long)1,(long)1,sizeof(int), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_int,&(f_dst_ip_serial),(long)1,(long)1,sizeof(int), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_int,&(f_port_src),(long)1,(long)1,sizeof(int), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_int,&(f_port_dst),(long)1,(long)1,sizeof(int), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_int,&(f_protocol_number),(long)1,(long)1,sizeof(int), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_char,(f_firstUpdate),(long)30,(long)1,30*sizeof(char), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_char,(f_lastUpdate),(long)30,(long)1,30*sizeof(char), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_int,&(f_packets),(long)1,(long)1,sizeof(int), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_int,&(f_volume),(long)1,(long)1,sizeof(int), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_char,&(f_interface),(long)0,(long)1,1*sizeof(char), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_int,&(f_flushed),(long)1,(long)1,sizeof(int), 
	ECPGt_int,&(ind_flushed),(long)1,(long)1,sizeof(int), ECPGt_EOIT, ECPGt_EORT);}
#line 172 "sqlwrite.ec"


	/*			:f_contents:ind_contents); */
	if (sqlca.sqlcode != 0) {//  && sqlca.sqlerrm.sqlerrml != 69) {
		syslog(LOG_MAKEPRI(LOG_DAEMON, LOG_ERR), "insert into usage Error %d message '%s'",
					sqlca.sqlerrm.sqlerrml, sqlca.sqlerrm.sqlerrmc);
		// delete f_contents;
		return false;
	}
	{ ECPGtrans(__LINE__, NULL, "commit");}
#line 181 "sqlwrite.ec"

	//delete f_contents;
	return true;
}

int	SQLGetDNS(string resolvedName, const struct in_addr& ip, const char *mac)
{
	int		retCode= 0;
	/* exec sql begin declare section */
	 	
		
		

	 	
	 	
	 	
			
	
#line 190 "sqlwrite.ec"
 int  f_serial   ;
 
#line 191 "sqlwrite.ec"
 char  f_hostname [ 512 ]   ;
 
#line 192 "sqlwrite.ec"
 char  f_ip_address [ 16 ]   ;
 
#line 194 "sqlwrite.ec"
 const char * q_hostname   ;
 
#line 195 "sqlwrite.ec"
 const char * q_ip_address   ;
 
#line 196 "sqlwrite.ec"
 const char * q_mac   ;
 
#line 197 "sqlwrite.ec"
 int  ind_mac   ;
/* exec sql end declare section */
#line 198 "sqlwrite.ec"


	q_hostname = resolvedName.c_str();
	q_ip_address = inet_to_string(ip).c_str();
	if (mac != NULL) {
		ind_mac = 1;
		q_mac = mac;
	} else {
		ind_mac = -1;
	}

	for (;;) {
		{ ECPGtrans(__LINE__, NULL, "begin transaction");}
#line 210 "sqlwrite.ec"

		{ ECPGdo(__LINE__, 0, 1, NULL, "select  serial  , hostname  , ip   from dnsentry where hostname  =  ? and ip  =  ?  ", 
	ECPGt_char,&(q_hostname),(long)0,(long)1,1*sizeof(char), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_char,&(q_ip_address),(long)0,(long)1,1*sizeof(char), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, ECPGt_EOIT, 
	ECPGt_int,&(f_serial),(long)1,(long)1,sizeof(int), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_char,(f_hostname),(long)512,(long)1,512*sizeof(char), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_char,(f_ip_address),(long)16,(long)1,16*sizeof(char), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, ECPGt_EORT);}
#line 214 "sqlwrite.ec"

		
		if (sqlca.sqlcode == 0) {
			retCode = f_serial;
			break;
		} else if (sqlca.sqlcode != ECPG_NOT_FOUND) {
			syslog(LOG_MAKEPRI(LOG_DAEMON, LOG_INFO), "select from dnsentry Error %d message '%s' ip '%s' host '%s'",
					sqlca.sqlerrm.sqlerrml, sqlca.sqlerrm.sqlerrmc, q_ip_address, q_hostname);
			{ ECPGtrans(__LINE__, NULL, "rollback");}
#line 222 "sqlwrite.ec"

			break;
		} else {
			{ ECPGdo(__LINE__, 0, 1, NULL, "insert into dnsentry ( hostname  , ip  , mac  ) values (  ? ,  ? ,  ? )", 
	ECPGt_char,&(q_hostname),(long)0,(long)1,1*sizeof(char), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_char,&(q_ip_address),(long)0,(long)1,1*sizeof(char), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_char,&(q_mac),(long)0,(long)1,1*sizeof(char), 
	ECPGt_int,&(ind_mac),(long)1,(long)1,sizeof(int), ECPGt_EOIT, ECPGt_EORT);}
#line 226 "sqlwrite.ec"


			if (sqlca.sqlcode != 0) {
				syslog(LOG_MAKEPRI(LOG_DAEMON, LOG_INFO), "insert into dnsentry Error %d message '%s'",
						sqlca.sqlerrm.sqlerrml, sqlca.sqlerrm.sqlerrmc);
				return 0;
			}
			// continue on to do select to get serial and return it.
		}
		{ ECPGtrans(__LINE__, NULL, "commit");}
#line 235 "sqlwrite.ec"

	}
	return retCode;
}

