struct my_ip {
	u_int8_t ip_vhl;		/* header length, version */
#define IP_V(ip)	(((ip)->ip_vhl & 0xf0) >> 4)
#define IP_HL(ip)	((ip)->ip_vhl & 0x0f)
	u_int8_t ip_tos;		/* type of service */
	u_int16_t ip_len;		/* total length */
	u_int16_t ip_id;		/* identification */
	u_int16_t ip_off;		/* fragment offset field */
#define	IP_DF 0x4000		/* dont fragment flag */
#define	IP_MF 0x2000		/* more fragments flag */
#define	IP_OFFMASK 0x1fff	/* mask for fragmenting bits */
	u_int8_t ip_ttl;		/* time to live */
	u_int8_t ip_p;		/* protocol */
	u_int16_t ip_sum;		/* checksum */
	struct in_addr ip_src, ip_dst;	/* source and dest address */
	u_int16_t port_src;
	u_int16_t port_dst;
};


inline string inet_to_string(struct in_addr ip) {
	char buf[4 + 4 + 4 + 5 + 1];
	unsigned char *ucp = (unsigned char *)&ip;
	sprintf(buf, "%d.%d.%d.%d",
		ucp[0] & 0xff,
		ucp[1] & 0xff,
		ucp[2] & 0xff,
		ucp[3] & 0xff);
	return string(buf);
}

inline string	port_to_string(u_int16_t port) {
	char	buf[32];
	sprintf(buf, "%u", port);
	return string(buf);
}

inline string	protocol_to_string(u_int8_t proto) {
	char	buf[32];
	sprintf(buf, "%u", (unsigned int)proto);
	return string(buf);
}

inline ostream& operator<<(ostream &os, struct in_addr ip) {
	os << inet_to_string(ip);
	return os;
}

