/* Module:          SQLGetTypeInfo.c
 *
 * Description:     Returns information about data types supported by the data source. 
 *
 * Classes:         
 *
 * API functions:   SQLGetTypeInfo
 *
 * Comments:        See "notice.txt" for copyright and license information.
 *
 */

#include "driver.h"

extern GLOBAL_VALUES globals;


SQLRETURN SQL_API SQLGetTypeInfo(
        SQLHSTMT   hDrvStmt,
        SQLSMALLINT   nSqlType)
{
static char *func = "SQLGetTypeInfo";
StatementClass *stmt = (StatementClass *) hDrvStmt;
TupleNode *row;
int i;
/* Int4 type; */
Int4 pgType; 
Int2 sqlType;

	mylog("%s: entering...nSqlType = %d\n", func, nSqlType);

	if( ! stmt) {
		SC_log_error(func, "", NULL);
		return SQL_INVALID_HANDLE;
	}


	stmt->manual_result = TRUE;
	stmt->result = QR_Constructor();
	if( ! stmt->result) {
		SC_log_error(func, "Error creating result.", stmt);
		return SQL_ERROR;
	}

	extend_bindings(stmt, 15);

	QR_set_num_fields(stmt->result, 15);
	QR_set_field_info(stmt->result, 0, "TYPE_NAME", PG_TYPE_TEXT, MAX_INFO_STRING);
	QR_set_field_info(stmt->result, 1, "DATA_TYPE", PG_TYPE_INT2, 2);
	QR_set_field_info(stmt->result, 2, "PRECISION", PG_TYPE_INT4, 4);
	QR_set_field_info(stmt->result, 3, "LITERAL_PREFIX", PG_TYPE_TEXT, MAX_INFO_STRING);
	QR_set_field_info(stmt->result, 4, "LITERAL_SUFFIX", PG_TYPE_TEXT, MAX_INFO_STRING);
	QR_set_field_info(stmt->result, 5, "CREATE_PARAMS", PG_TYPE_TEXT, MAX_INFO_STRING);
	QR_set_field_info(stmt->result, 6, "NULLABLE", PG_TYPE_INT2, 2);
	QR_set_field_info(stmt->result, 7, "CASE_SENSITIVE", PG_TYPE_INT2, 2);
	QR_set_field_info(stmt->result, 8, "SEARCHABLE", PG_TYPE_INT2, 2);
	QR_set_field_info(stmt->result, 9, "UNSIGNED_ATTRIBUTE", PG_TYPE_INT2, 2);
	QR_set_field_info(stmt->result, 10, "MONEY", PG_TYPE_INT2, 2);
	QR_set_field_info(stmt->result, 11, "AUTO_INCREMENT", PG_TYPE_INT2, 2);
	QR_set_field_info(stmt->result, 12, "LOCAL_TYPE_NAME", PG_TYPE_TEXT, MAX_INFO_STRING);
	QR_set_field_info(stmt->result, 13, "MINIMUM_SCALE", PG_TYPE_INT2, 2);
	QR_set_field_info(stmt->result, 14, "MAXIMUM_SCALE", PG_TYPE_INT2, 2);

	for(i=0, sqlType = sqlTypes[0]; sqlType; sqlType = sqlTypes[++i]) {
		pgType = sqltype_to_pgtype(sqlType);

		if (nSqlType == SQL_ALL_TYPES || nSqlType == sqlType) {
			row = (TupleNode *)malloc(sizeof(TupleNode) + (15 - 1)*sizeof(TupleField));

			/*	These values can't be NULL */
			set_tuplefield_string(&row->tuple[0], pgtype_to_name(stmt, pgType));
			set_tuplefield_int2(&row->tuple[1], (Int2) sqlType);
			set_tuplefield_int2(&row->tuple[6], pgtype_nullable(stmt, pgType));
			set_tuplefield_int2(&row->tuple[7], pgtype_case_sensitive(stmt, pgType));
			set_tuplefield_int2(&row->tuple[8], pgtype_searchable(stmt, pgType));
			set_tuplefield_int2(&row->tuple[10], pgtype_money(stmt, pgType));

			/*	Localized data-source dependent data type name (always NULL) */
			set_tuplefield_null(&row->tuple[12]);	

			/*	These values can be NULL */
			set_nullfield_int4(&row->tuple[2], pgtype_precision(stmt, pgType, PG_STATIC, PG_STATIC));
			set_nullfield_string(&row->tuple[3], pgtype_literal_prefix(stmt, pgType));
			set_nullfield_string(&row->tuple[4], pgtype_literal_suffix(stmt, pgType));
			set_nullfield_string(&row->tuple[5], pgtype_create_params(stmt, pgType));
			set_nullfield_int2(&row->tuple[9], pgtype_unsigned(stmt, pgType));
			set_nullfield_int2(&row->tuple[11], pgtype_auto_increment(stmt, pgType));
			set_nullfield_int2(&row->tuple[13], pgtype_scale(stmt, pgType, PG_STATIC));
			set_nullfield_int2(&row->tuple[14], pgtype_scale(stmt, pgType, PG_STATIC));

			QR_add_tuple(stmt->result, row);
		}
	}


    stmt->status = STMT_FINISHED;
    stmt->currTuple = -1;
	stmt->rowset_start = -1;
	stmt->current_col = -1;

    return SQL_SUCCESS;
}
