/* Module:          SQLFreeConnect.c
 *
 * Description:     Has been replaced by SQLFreeHandle. 
 *
 * Classes:         
 *
 * API functions:   SQLFreeConnect
 *
 * Comments:        See "notice.txt" for copyright and license information.
 *
 */

#include "driver.h"

SQLRETURN SQL_API SQLFreeConnect(SQLHDBC	hDrvDbc)
{
	ConnectionClass *conn = (ConnectionClass *) hDrvDbc;
	static char *func = "SQLFreeConnect";

	mylog( "%s: entering...\n", func);
	mylog("**** in %s: hDrvDbc=%u\n", func, hDrvDbc);

	if ( ! conn)
	{
		CC_log_error(func, "", NULL);
		return SQL_INVALID_HANDLE;
	}

	/*  Remove the connection from the environment */
	if ( ! EN_remove_connection(conn->henv, conn))
	{
		conn->errornumber = CONN_IN_USE;
		conn->errormsg = "A transaction is currently being executed";
		CC_log_error(func, "", conn);
		return SQL_ERROR;
	}

	CC_Destructor(conn);

	mylog("%s: returning...\n", func);

	return SQL_SUCCESS;
}
