/* Module:          SQLDescribeParam.c
 *
 * Description:     Returns the description of a parameter marker associated 
 *					with a prepared SQL statement. 
 *
 * Classes:         
 *
 * API functions:   SQLDescribeParam
 *
 * Comments:        See "notice.txt" for copyright and license information.
 *
 */

#include "driver.h"
/* HERES THE CORRECT WAY...
SQLRETURN SQLDescribeParam( SQLHSTMT      hDrvStmt,
                                  SQLUSMALLINT  nParmNumber,
                                  SQLSMALLINT   *pnDataType,
                                  SQLUINTEGER   *pnSize,
                                  SQLSMALLINT   *pnDecDigits,
                                  SQLSMALLINT   *pnNullable )
HERES THE WAY THAT WORKS... */

/*  SQLRETURN SQL_API SQLDescribeParam(
    SQLHSTMT           hstmt,
    SQLUSMALLINT       ipar,
    SQLSMALLINT 	  *pfSqlType,
    SQLUINTEGER 	  *pcbParamDef,
    SQLSMALLINT 	  *pibScale,
    SQLSMALLINT 	  *pfNullable);
*/

SQLRETURN SQL_API SQLDescribeParam(
						   SQLHSTMT			hDrvStmt,
						   SQLUSMALLINT		nParmNumber,
						   SQLSMALLINT		*pnDataType,
						   SQLUINTEGER		*pnSize,
						   SQLSMALLINT		*pnDecDigits,
						   SQLSMALLINT		*pnNullable
						   )

{
	StatementClass *stmt = (StatementClass *) hDrvStmt;
	static char *func = "SQLDescribeParam";

	mylog( "%s: entering...\n", func);

	if( ! stmt)
	{
		SC_log_error(func, "", NULL);
		return SQL_INVALID_HANDLE;
	}

	if( (nParmNumber < 1) || (nParmNumber > stmt->parameters_allocated) )
	{
		stmt->errormsg = "Invalid parameter number for SQLDescribeParam.";
		stmt->errornumber = STMT_BAD_PARAMETER_NUMBER_ERROR;
		SC_log_error(func, "", stmt);
		return SQL_ERROR;
	}

	nParmNumber--;

	/*	This implementation is not very good, since it is supposed to describe */
	/*	parameter markers, not bound parameters.  */
	if(pnDataType)
	{
		*pnDataType = stmt->parameters[nParmNumber].SQLType;
	}
	
	if(pnSize)
	{
		*pnSize = stmt->parameters[nParmNumber].precision;
	}

	if(pnDecDigits)
	{
		*pnDecDigits = stmt->parameters[nParmNumber].scale;
	}

	if(pnNullable)
	{
		*pnNullable = pgtype_nullable(stmt, stmt->parameters[nParmNumber].paramType);
	}

	return SQL_SUCCESS;
}

