/* $PostgresPy: if/src/type.c,v 1.7 2004/07/27 16:25:32 flaw Exp $
 * 
 * † Instrument:
 *     Copyright 2004, rhid development. All Rights Reserved.
 *     
 *     Usage of the works is permitted provided that this
 *     instrument is retained with the works, so that any entity
 *     that uses the works is notified of this instrument.
 *     
 *     DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
 *     
 *     [2004, Fair License; rhid.com/fair]
 *     
 * Description:
 *    Postgres type interface
 */
#include <pputils.h>

#include <postgres.h>
#include <access/heapam.h>
#include <utils/array.h>
#include <utils/syscache.h>
#include <catalog/pg_type.h>
#include <catalog/pg_cast.h>
#include <nodes/params.h>
#include <pg.h>

#include <Python.h>
#include <structmember.h>
#include <py.h>

#include "datum.h"
#include "tupd.h"
#include "tup.h"
#include "obj.h"
#include "utils.h"
#include "module.h"
#include "type.h"

PyObj
type_cast(PgType self, PyObj ob)
{
	HeapTuple tup;
	Oid from, to, castor;
	Datum rd;
	PyObj rob;

	if (!PgObj_TypeCheck(ob))
	{
		PyErr_Format(PyExc_TypeError,
			"expecting a Postgres.Object, got %s",
			ob->ob_type->tp_name);
		return(NULL);
	}
	
	from = ObjectIdGetDatum(PgObj_FetchTypeOid(ob));
	to = ObjectIdGetDatum(PgType_FetchOid(self));
	tup = SearchSysCache(CASTSOURCETARGET, from, to, 0, 0);
	if (tup == NULL)
	{
		char *fromTypeStr, *toTypeStr;
		fromTypeStr = PgTypeName_FromOid(from);
		toTypeStr = PgTypeName_FromOid(to);

		PyErr_Format(PyExc_TypeError,
				"no function for casting a '%s' object to a '%s' object",
				fromTypeStr, toTypeStr);

		pfree(fromTypeStr);
		pfree(toTypeStr);
		return(NULL);
	}

	castor = CASTSTRUCT(tup)->castfunc;
	ReleaseSysCache(tup);

	rd = OidFunctionCall1(castor, PgObj_FetchDatum(ob));
	rob = PyPgObject_New(rd, (PyObj)self);

	return(rob);
}

PyObj
type_bin(PgType self, PyObj bin)
{
	RETURN_NONE;
}

static PyMethodDef PyPgType_Methods[] = {
	{"cast", (PyCFunction)type_cast, METH_O,
		"cast a Postgres.Object to a new object of this type"},
	{"binary", (PyCFunction)type_bin, METH_O,
		"create a Postgres.Object of this type from the given raw data"
		"and this type's binary input function"},

	{NULL}
};

static void
type_dealloc(PgType self)
{
	DECREF(self->ob_tuple);
	self->ob_tuple = NULL;

	PyObject_Del((PyObj)self);
}

static PyObj
type_getattr(PgType self, char *attr)
{
	PyObj rob;
	if (!strcmp(attr, "tuple"))
	{
		rob = self->ob_tuple;
		INCREF(rob);
	}
	else if (!strcmp(attr, "oid"))
		rob = PyObject_GetAttrString(self->ob_tuple, "oid");
	else
		rob = PyMapping_GetItemString(self->ob_tuple, attr);

	return(rob);
}

static PyObj
type_repr(PgType self)
{
	char *tp_name, *typname;
	PyObj rob;

	tp_name = self->ob_type->tp_name;
	typname = NameStr(TOTYPESTRUCT(self)->typname);

	rob = PYSTRF("<%s %s>", tp_name, typname);

	return(rob);
}

static PyObj
type_str(PyObj self)
{
	char *typname;
	PyObj rob;

	typname = NameStr(TOTYPESTRUCT(self)->typname);
	rob = PYSTR(typname);
	return(rob);
}

static PyObj
type_call(PyObj self, PyObj args, PyObj kw)
{
	PyObj ob = NULL, rob = NULL;
	Form_pg_type typs;

	if (PyCFunctionErr_NoKeywordsAllowed(kw))
		return(NULL);

	typs = TOTYPESTRUCT(self);
	
	if (typs->typrelid)
	{
		PyObj tdo;

		tdo = PyPgTupleDesc_New(RelationOidGetDescr(typs->typrelid));
		rob = PyObject_Call(tdo, args, NULL);
		DECREF(tdo);
	}
	else if (typs->typelem)
	{
		rob = PgObj_FromArrayTypeTupleAndPySequence(PgType_FetchHT(self), args);
	}
	else
	{
		if (!PyArg_ParseTuple(args, "O", &ob))
			return(NULL);
			
		if (PgObj_TypeCheck(ob))
		{
			HeapTuple tup;
			Oid from, to, castor;
			Datum rd;

			from = ObjectIdGetDatum(PgObj_FetchTypeOid(ob));
			to = ObjectIdGetDatum(PgType_FetchOid(self));
			tup = SearchSysCache(CASTSOURCETARGET, from, to, 0, 0);
			if (tup == NULL)
			{
				char *fromTypeStr, *toTypeStr;
				fromTypeStr = PgTypeName_FromOid(from);
				toTypeStr = PgTypeName_FromOid(to);

				PyErr_Format(PyExc_TypeError,
						"no function for casting a '%s' object to a '%s' object",
						fromTypeStr, toTypeStr);

				pfree(fromTypeStr);
				pfree(toTypeStr);
				return(NULL);
			}

			castor = CASTSTRUCT(tup)->castfunc;
			ReleaseSysCache(tup);

			rd = OidFunctionCall1(castor, PgObj_FetchDatum(ob));
			rob = PyPgObject_New(rd, self);
		}
		else
		{
			PyObj obstr;
			Datum rd;
			obstr = PyObject_Str(ob);

			rd = OidFunctionCall1(typs->typinput, PointerGetDatum(PYASSTR(obstr)));
			DECREF(obstr);
			rob = PyPgObject_New(rd, self);
		}
	}

	return(rob);
}

/*
 * type_new - all initialization is done here
 */
PyObj
type_new(PyTypeObject *subtype, PyObj args, PyObj kw)
{
	PyObj ob = NULL, hto, rob;
	HeapTuple ht;
	PgType typ;
	Oid typoid;
	int32 mod = -1;

	if (PyCFunctionErr_NoKeywordsAllowed(kw)
		|| !PyArg_ParseTuple(args, "O", &ob))
		return(NULL);

	typoid = TypeOidMod_FromPyObject(ob, &mod);
	if (typoid == InvalidOid)
	{
		if (PyErr_Occurred())
			return(NULL);
		else
			goto Error;
	}

	/* XXX: Implement type object cache based on Oid */

	ht = TypeHT_FromTypeOid(typoid);
	if (ht == NULL)
		goto Error;
	HeapTupleSetOid(ht, typoid);

	hto = PyPgTuple_New(ht, PyPgTypeTDO);
	if (hto == NULL)
	{
		heap_freetuple(ht);
		goto Error;
	}

	typ = (PgType) subtype->tp_alloc(subtype, 0);
	typ->ob_tuple = hto;
	rob = PyObj(typ);

	return(rob);
Error:
	{
		PyObj obstr;
		obstr = PyObject_Str(ob);
		PyErr_Format(PyExc_TypeError,
			"Postgres Type '%s' does not exist", PYASSTR(obstr));
		DECREF(obstr);
		return(NULL);
	}
}

static char PyPgTypeType_Doc[] = 
"Python type for a Postgres Type";

PyTypeObject PyPgType_Type = {
	PyObject_HEAD_INIT(NULL)
	0,									/* ob_size */
	"Postgres.Type",				/* tp_name */
	sizeof(struct PyPgType),	/* tp_basicsize */
	0,									/* tp_itemsize */
	(destructor)type_dealloc,	/* tp_dealloc */
	NULL,								/* tp_print */
	(getattrfunc)type_getattr,	/* tp_getattr */
	(setattrfunc)0,				/* tp_setattr */
	(cmpfunc)0,						/* tp_compare */
	(reprfunc)type_repr,			/* tp_repr */
	NULL,								/* tp_as_number */
	NULL,								/* tp_as_sequence */
	NULL,								/* tp_as_mapping */
	(hashfunc)NULL,				/* tp_hash */
	(ternaryfunc)type_call,		/* tp_call */
	(reprfunc)type_str,			/* tp_str */
	NULL,								/* tp_getattro */
	NULL,								/* tp_setattro */
	NULL,								/* tp_as_buffer */
	Py_TPFLAGS_DEFAULT,			/* tp_flags */
	(char*)PyPgTypeType_Doc,	/* tp_doc */
	(traverseproc)NULL,			/* tp_traverse */
	(inquiry)NULL,					/* tp_clear */
	(richcmpfunc)NULL,			/* tp_richcompare */
	(long)NULL,						/* tp_weaklistoffset */
	(getiterfunc)NULL,			/* tp_iter */
	(iternextfunc)NULL,			/* tp_iternext */
	PyPgType_Methods,				/* tp_methods */
	NULL,								/* tp_members */
	NULL,								/* tp_getset */
	NULL,								/* tp_base */
	NULL,								/* tp_dict */
	NULL,								/* tp_descr_get */
	NULL,								/* tp_descr_set */
	NULL,								/* tp_dictoffset */
	(initproc)NULL,				/* tp_init */
	NULL,								/* tp_alloc */
	(newfunc)type_new,			/* tp_new */
};

PyObj
PyPgType_New(PyObj typehto)
{
	PgType rob;
	
	Assert(PgTup_CheckType(hto));

	rob = PgType(PgType_NEW());
	INCREF(typehto);
	rob->ob_tuple = typehto;
	return(PyObj(rob));
}

PyObj
PgType_FromTypeOid(Oid to)
{
	HeapTuple ht;
	PyObj hto, rob;
	
	ht = TypeHT_FromTypeOid(to);
	if (ht == NULL)
		return(NULL);
	
	hto = PyPgTuple_New(ht, PyPgTypeTDO);
	rob = PyPgType_New(hto);
	DECREF(hto);
	return(rob);
}

PyObj
PgType_FromHeapTuple(HeapTuple ht)
{
	return(NULL);
}

PyObj
PgType_FromPyObject(PyObj ob)
{
	return(NULL);
}
