/* $PostgresPy: if/include/pputils.h,v 1.8 2004/07/28 11:27:44 flaw Exp $
 *
 * † Instrument:
 *     Usage of the works is permitted provided that this
 *     instrument is retained with the works, so that any entity
 *     that uses the works is notified of this instrument.
 *     
 *     DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
 *     
 *     [2004, Fair License; rhid.com/fair]
 *     
 * Description:
 *    Various preprocessor utilities.
 */
#ifndef PPUTILS_H
#define PPUTILS_H "pputils.h"
#ifdef __cplusplus
extern "C" {
#endif

#define VOID

#define STR(V) #V
#define XSTR(V) STR(V)
#define CATLIT(ONE,TWO) ONE##TWO

#define __SLINE__ XSTR(__LINE__)

#define LOCATION_ARGS const char *const _file_L, \
							 const int _line_L, \
							 const char *const _func_L
#define LOCATION_VARS _file_L, _line_L, _func_L

#define LOCATION_FM "File \"%s\", line %d, in %s"

#define __LOCATIONA__ __FILE__, __LINE__, __func__
#define __LOCATION__			\
	"File \""	__FILE__		\
	"\", line "	__SLINE__	\
	", in "		__func__

/*
 * Functionify Macro (Make like a single Function)
 */
#define FMACRO(V) do{V}while(0)
#ifdef DEBUG
#	define DMACRO(V) do{V}while(0)
#else
#	define DMACRO(V) do{ }while(0)
#endif

/* inline specifier */
#if !defined(__cplusplus) && !defined(__C99__)
#if defined(__GNUC__)
#define inline static __inline__
#else
#define inline static
#endif
#endif

#ifdef __cplusplus
}
#endif
#endif
