/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.BufferedInputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class ClobValue
extends Reader
implements Clob {
    private final Reader m_reader;
    private final long m_nChars;
    private long m_readerPos;
    private long m_markPos;

    public ClobValue(String value) {
        this(new StringReader(value), value.length());
    }

    public ClobValue(Reader reader, long nChars) {
        this.m_reader = reader;
        this.m_nChars = nChars;
        this.m_readerPos = 0L;
        this.m_markPos = 0L;
    }

    public long length() {
        return this.m_nChars;
    }

    public InputStream getAsciiStream() {
        return new BufferedInputStream(new InputStream(){

            public int read() throws IOException {
                int nextChar = ClobValue.this.read();
                if (nextChar > 127) {
                    throw new CharConversionException("Non ascii character in Clob data");
                }
                return nextChar;
            }
        });
    }

    public Reader getCharacterStream() {
        return this;
    }

    public String getSubString(long pos, int length) throws SQLException {
        if (pos < 0L || length < 0) {
            throw new IllegalArgumentException();
        }
        if (length == 0) {
            return "";
        }
        if (pos + (long)length > this.m_nChars) {
            throw new SQLException("Attempt to read beyond end of Clob data");
        }
        long skip = pos - this.m_readerPos;
        if (skip < 0L) {
            throw new SQLException("Cannot position Clob stream backwards");
        }
        try {
            char[] buf;
            int nr;
            if (skip > 0L) {
                this.skip(skip);
            }
            if ((nr = this.read(buf = new char[length])) < length) {
                throw new SQLException("Clob data read not fulfilled");
            }
            return new String(buf);
        }
        catch (IOException e) {
            throw new SQLException("Error reading Blob data: " + e.getMessage());
        }
    }

    public long position(String pattern, long start) {
        throw new UnsupportedOperationException();
    }

    public long position(Clob pattern, long start) {
        throw new UnsupportedOperationException();
    }

    public OutputStream setAsciiStream(long pos) {
        throw new UnsupportedOperationException();
    }

    public Writer setCharacterStream(long pos) {
        throw new UnsupportedOperationException();
    }

    public int setString(long pos, String str) {
        throw new UnsupportedOperationException();
    }

    public int setString(long pos, String str, int offset, int len) {
        throw new UnsupportedOperationException();
    }

    public void truncate(long len) {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        this.m_reader.close();
        this.m_readerPos = 0L;
        this.m_markPos = 0L;
    }

    public boolean markSupported() {
        return this.m_reader.markSupported();
    }

    public synchronized void mark(int readLimit) throws IOException {
        this.m_reader.mark(readLimit);
        this.m_markPos = this.m_readerPos;
    }

    public synchronized int read() throws IOException {
        int rs = this.m_reader.read();
        ++this.m_readerPos;
        return rs;
    }

    public synchronized int read(char[] b) throws IOException {
        int rs = this.m_reader.read(b);
        this.m_readerPos += (long)rs;
        return rs;
    }

    public synchronized int read(char[] b, int off, int len) throws IOException {
        int rs = this.m_reader.read(b, off, len);
        this.m_readerPos += (long)rs;
        return rs;
    }

    public synchronized long skip(long nBytes) throws IOException {
        long skipped = this.m_reader.skip(nBytes);
        this.m_readerPos += skipped;
        return skipped;
    }

    public synchronized boolean ready() throws IOException {
        return this.m_reader.ready();
    }

    public synchronized void reset() throws IOException {
        this.m_reader.reset();
        this.m_readerPos = this.m_markPos;
    }
}

