/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.sqlj;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class EntryStreamHandler
extends URLStreamHandler {
    private static EntryStreamHandler s_instance;

    EntryStreamHandler() {
    }

    protected URLConnection openConnection(URL uRL) throws IOException {
        return new EntryConnection(uRL);
    }

    static URLStreamHandler getInstance() {
        if (s_instance == null) {
            s_instance = new EntryStreamHandler();
        }
        return s_instance;
    }

    class EntryConnection
    extends URLConnection {
        private final int m_entryId;
        private String m_entryName;
        private byte[] m_image;

        protected EntryConnection(URL uRL) {
            super(uRL);
            this.m_entryId = Integer.parseInt(this.url.getPath().substring(1));
        }

        public void connect() throws IOException {
            block17: {
                if (this.connected) {
                    return;
                }
                PreparedStatement preparedStatement = null;
                ResultSet resultSet = null;
                try {
                    Connection connection = DriverManager.getConnection("jdbc:default:connection");
                    preparedStatement = connection.prepareStatement("SELECT entryName, entryImage FROM sqlj.jar_entry WHERE entryId = ?");
                    preparedStatement.setInt(1, this.m_entryId);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        this.m_entryName = resultSet.getString(1);
                        this.m_image = resultSet.getBytes(2);
                        this.connected = true;
                        break block17;
                    }
                    throw new FileNotFoundException("jarId = " + this.m_entryId);
                }
                catch (SQLException sQLException) {
                    throw new IOException(sQLException.getMessage());
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
        }

        public InputStream getInputStream() throws IOException {
            this.connect();
            return new ByteArrayInputStream(this.m_image);
        }

        public String getContentType() {
            return EntryConnection.getFileNameMap().getContentTypeFor(this.m_entryName);
        }
    }
}

