/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.SQLException;
import org.postgresql.pljava.jdbc.AbstractResultSetMetaData;
import org.postgresql.pljava.jdbc.ResultSetField;

public class SyntheticResultSetMetaData
extends AbstractResultSetMetaData {
    private final ResultSetField[] m_fields;

    public SyntheticResultSetMetaData(ResultSetField[] resultSetFieldArray) {
        this.m_fields = resultSetFieldArray;
    }

    public final int getColumnCount() throws SQLException {
        return this.m_fields.length;
    }

    public final boolean isAutoIncrement(int n) throws SQLException {
        this.checkColumnIndex(n);
        return false;
    }

    public final String getColumnLabel(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.m_fields[n - 1].getColumnLabel();
    }

    public final String getColumnClassName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.m_fields[n - 1].getJavaClass().getName();
    }

    protected final void checkColumnIndex(int n) throws SQLException {
        if (n < 1 || n > this.m_fields.length) {
            throw new SQLException("Invalid column index: " + n);
        }
    }

    protected final int getOid(int n) throws SQLException {
        return this.m_fields[n - 1].getOID();
    }

    protected final int getFieldLength(int n) throws SQLException {
        return this.m_fields[n - 1].getLength();
    }
}

