/* Written by Morgoth DBMA, morgothdbma@o2.pl
 This is part of PgXexplorer software, Open Source
 on BSD licence, Libraries(interaces) used:
 GNU GCC, AS (all stuff needed to compile C source into executable binary)
 LibPQ-FE from PostgreSQL, GTK (GIMP Toolkit)
 written in VIM editor, ctags used, CVS used
 Currently only one author: MOrgoth DBMA
 FILE: consoleout.c */
#include "consoleout.h"

int debug(char* fmt, ...)
{
#ifdef DEBUG
 va_list ap;
 int err;
 va_start(ap,fmt);
 printf("debug: ");
 err = vprintf(fmt,ap);
 va_end(ap);
 return err;
#endif
#ifndef DEBUG
 return 0;
#endif
}


int fatal(char* fmt, ...)
{
 va_list ap;
 va_start(ap,fmt);
 printf("\n\nPANIC\n\t%c%cfatal: ",7,7);
 vprintf(fmt,ap);
 printf("\nApplication Terminated.%c%c\n\n", 7,7);
 va_end(ap);
 exit(1);
}


int error(char* fmt, ...)
{
 va_list ap;
 int err;
 va_start(ap,fmt);
 printf("error: ");
 err = vprintf(fmt,ap);
 va_end(ap);
 return err;
}


void print_results(char*** res, int a, int b)
{
 int i,j;
 ln();
 if (!res) return;
 for (i=0;i<a;i++)
   {
    for (j=0;j<b;j++) printf("%-16s ", res[i][j]);
    ln();
   }
 ln();
}

