<?

/* orders.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include("../application.inc.php");
require_login();

$DOC_TITLE = $Orders_Log_cc;
include("$CFG->templatedir"."header.ihtml");

switch (nvl($mode)) {
	case "details" :
		show_order_details($id, $SESSION["user"]["username"]);
		break;

	default :
		print_order_list($SESSION["user"]["username"]);
		break;
}

include("$CFG->templatedir"."footer.ihtml");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function show_order_details($id, $username) {
/* loads up the details for an order and displays it */

	global $CFG, $ME;
	global $SESSION;
	global $weightunity;
	global $page_number;
	include ($CFG->global);

	$qid_order = db_query("
	SELECT o.*, os.name AS state_name
	FROM orderscc o, orders_states os
	WHERE o.state_id = os.id AND o.id = '$id'
	");
	if (db_num_rows($qid_order) < 1) {
		include("templates/no_such_order.ihtml");
		return;
	}
	$qid_items = db_query("
	SELECT
		 oi.product_id
		,p.name
		,p.price AS curr_price
		,oi.price AS purchase_price
		,oi.iva AS purchase_iva
		,oi.weight AS purchase_weight
		,oi.qty
		,oi.price * oi.qty AS total
	FROM	order_items oi, products p
	WHERE	oi.product_id = p.id AND order_id = '$id'
	UNION
	SELECT
		 oi.product_id
		,'-' as name
		,0 as curr_price
		,oi.price AS purchase_price
		,oi.iva AS purchase_iva
		,oi.weight AS purchase_weight
		,oi.qty
		,oi.price * oi.qty AS total
	FROM order_items oi
	WHERE order_id = '$id' AND
		NOT EXISTS
		(
			SELECT
				id
			FROM products
			WHERE id = oi.product_id
		)
	");
/* For MySQL
	$qid_items = db_query("
	SELECT
		 oi.product_id
		,p.name
		,p.price AS curr_price
		,oi.price AS purchase_price
		,oi.iva AS purchase_iva
		,oi.weight AS purchase_weight
		,oi.qty
		,oi.price * oi.qty AS total
	FROM	order_items oi LEFT JOIN products p ON (oi.product_id = p.id)
	WHERE	order_id = '$id'
	");
*/

	$order = db_fetch_object($qid_order, 0);

	$qid_user = db_query("
	SELECT usertype, fiscalcode, email
	FROM users
	WHERE username = '$order->username'
	");
	$user = db_fetch_object($qid_user, 0);

	include("templates/order_details.ihtml");
}

function print_order_list($username) {
/* reads a list of orders from the database and displays them, we will use
 * a template to display the listings to keep this main script clean */

	global $CFG, $ME;
	global $SESSION;
	global $weightunity;
	global $page_number, $dbchanged;
	include ($CFG->global);

	if (!isset($page_number) || $dbchanged) {
		$qid = db_query("
		SELECT o.id, o.username, o.date, o.custinfo, o.amount, o.notes, os.name AS state_name
		FROM orderscc o, orders_states os
		WHERE o.state_id = os.id AND username = '$username'
		ORDER BY os.name, o.id ASC
  		");

		$SESSION["numr"] = db_num_rows($qid);
		for ($i=0; $i<$SESSION["numr"]; $i++) {
			$SESSION["orderscc"][$i] = db_fetch_array($qid, $i);
		}
		if (!isset($page_number)) {
			$page_number = 1;
		}
	}

	if ($SESSION["numr"] > $SESSION["orders_per_page"]) {
		$first = ($page_number-1)*$SESSION["orders_per_page"];
		$last = $SESSION["numr"] < $page_number*$SESSION["orders_per_page"] ? $SESSION["numr"]-1 : $page_number*$SESSION["orders_per_page"]-1;
		$num_pages = $SESSION["numr"] / $SESSION["orders_per_page"];
		if (!($num_pages == (integer) $num_pages)) {
			$num_pages = (integer) $num_pages + 1;
		}
	} else {
		$first = 0;
		$last = $SESSION["numr"] - 1;
	}

	if ($SESSION["numr"] == 0)
		include("templates/no_orders.ihtml");
	else
		include("templates/ordercc_list.ihtml");
}

?>
