<?
/* users.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi (pratesi@telug.it) */
/* (c) 2000 Fabio Molinari (fabio.m@mclink.it) */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include("../application.inc.php");
require_login();
require_priv("admin");

if (!isset($usertype)) { $usertype = "pf"; }

$DOC_TITLE = $Users_Admin;
include("templates/header.ihtml");

switch (nvl($mode)) {
	case "details" :
		show_user_details($username);
		break;

	case "add" :
		print_add_user_form($usertype);
		break;

	case "edit" :
		print_edit_user_form($username);
		break;

	case "del" :
		delete_user($username);
		print_user_list();
		break;

	case "insert" :
        	$errors = new Object;
        	$errormsg = "";
        	validate_username($HTTP_POST_VARS["username"], &$errors, &$errormsg);
        	validate_priv($HTTP_POST_VARS["priv"], &$errors, &$errormsg);
		if ($HTTP_POST_VARS["usertype"] == "pf") {
        		validate_firstname($HTTP_POST_VARS["firstname"], &$errors, &$errormsg);
        		validate_lastname($HTTP_POST_VARS["lastname"], &$errors, &$errormsg);
			if (!empty($HTTP_POST_VARS["fiscalcode"])) {
        			validate_fiscalcode($HTTP_POST_VARS["fiscalcode"], &$errors, &$errormsg);
			}
		} else if ($HTTP_POST_VARS["usertype"] == "az") {
			validate_ragionesociale($HTTP_POST_VARS["firstname"], &$errors, &$errormsg);
			validate_partitaiva($HTTP_POST_VARS["fiscalcode"], &$errors, &$errormsg);
		}
        	validate_address($HTTP_POST_VARS["address"], &$errors, &$errormsg);
        	validate_number($HTTP_POST_VARS["number"], &$errors, &$errormsg);
        	validate_city($HTTP_POST_VARS["city"], &$errors, &$errormsg);
        	validate_state($HTTP_POST_VARS["state"], &$errors, &$errormsg);
        	validate_zip_code($HTTP_POST_VARS["zip_code"], &$errors, &$errormsg);
        	validate_phone($HTTP_POST_VARS["phone"], &$errors, &$errormsg);
        	validate_fax($HTTP_POST_VARS["fax"], &$errors, &$errormsg);
        	validate_mobilephone($HTTP_POST_VARS["mobilephone"], &$errors, &$errormsg);
        	validate_email($HTTP_POST_VARS["email"], &$errors, &$errormsg);
        	validate_notes($HTTP_POST_VARS["notes"], &$errors, &$errormsg);
        	validate_ournotes($HTTP_POST_VARS["ournotes"], &$errors, &$errormsg);
		if (username_exists($HTTP_POST_VARS["username"])) {
			$errors->username = true;
			$errormsg = "<li>" . $the_username . " <b>" . ov($HTTP_POST_VARS["username"]) ."</b> " . $already_exists . $errormsg;
		}
/*
        	if (email_exists($HTTP_POST_VARS["email"])) {
                	$errors->email = true;
                	$errormsg .= "<li>" . $the_email_address . " <b>" . ov($HTTP_POST_VARS["email"]) ."</b> " . $already_exists;
        	}
*/
		if (empty($errormsg)) {
			insert_user($HTTP_POST_VARS);
			print_user_list();
		} else {
			$frm["username"] = $HTTP_POST_VARS["username"];
			$frm["usertype"] = $HTTP_POST_VARS["usertype"];
			$frm["priv"] = $HTTP_POST_VARS["priv"];
			$frm["firstname"] = $HTTP_POST_VARS["firstname"];
			$frm["lastname"] = $HTTP_POST_VARS["lastname"];
			$frm["fiscalcode"] = $HTTP_POST_VARS["fiscalcode"];
			$frm["address"] = $HTTP_POST_VARS["address"];
			$frm["number"] = $HTTP_POST_VARS["number"];
			$frm["city"] = $HTTP_POST_VARS["city"];
			$frm["state"] = $HTTP_POST_VARS["state"];
			$frm["zip_code"] = $HTTP_POST_VARS["zip_code"];
			$frm["phone"] = $HTTP_POST_VARS["phone"];
			$frm["fax"] = $HTTP_POST_VARS["fax"];
			$frm["mobilephone"] = $HTTP_POST_VARS["mobilephone"];
			$frm["email"] = $HTTP_POST_VARS["email"];
			$frm["authdata"] = $HTTP_POST_VARS["authdata"];
			$frm["acceptadvert"] = $HTTP_POST_VARS["acceptadvert"];
			$frm["notes"] = $HTTP_POST_VARS["notes"];
			$frm["ournotes"] = $HTTP_POST_VARS["ournotes"];
			$frm["newmode"] = "insert";
			$frm["submit_caption"] = $Add_User;
			include("$CFG->templatedir"."form_header.ihtml");
			include("templates/user_form-".$HTTP_POST_VARS["usertype"].".ihtml");
		}
		break;

	case "update" :
        	$errors = new Object;
        	$errormsg = "";
        	validate_priv($HTTP_POST_VARS["priv"], &$errors, &$errormsg);
		if ($HTTP_POST_VARS["usertype"] == "pf") {
        		validate_firstname($HTTP_POST_VARS["firstname"], &$errors, &$errormsg);
        		validate_lastname($HTTP_POST_VARS["lastname"], &$errors, &$errormsg);
			if (!empty($HTTP_POST_VARS["fiscalcode"])) {
        			validate_fiscalcode($HTTP_POST_VARS["fiscalcode"], &$errors, &$errormsg);
			}
		} else if ($HTTP_POST_VARS["usertype"] == "az") {
			validate_ragionesociale($HTTP_POST_VARS["firstname"], &$errors, &$errormsg);
			validate_partitaiva($HTTP_POST_VARS["fiscalcode"], &$errors, &$errormsg);
		}
        	validate_address($HTTP_POST_VARS["address"], &$errors, &$errormsg);
        	validate_number($HTTP_POST_VARS["number"], &$errors, &$errormsg);
        	validate_city($HTTP_POST_VARS["city"], &$errors, &$errormsg);
        	validate_state($HTTP_POST_VARS["state"], &$errors, &$errormsg);
        	validate_zip_code($HTTP_POST_VARS["zip_code"], &$errors, &$errormsg);
        	validate_phone($HTTP_POST_VARS["phone"], &$errors, &$errormsg);
        	validate_fax($HTTP_POST_VARS["fax"], &$errors, &$errormsg);
        	validate_mobilephone($HTTP_POST_VARS["mobilephone"], &$errors, &$errormsg);
        	validate_email($HTTP_POST_VARS["email"], &$errors, &$errormsg);
        	validate_notes($HTTP_POST_VARS["notes"], &$errors, &$errormsg);
        	validate_ournotes($HTTP_POST_VARS["ournotes"], &$errors, &$errormsg);
/*
        	if ($HTTP_POST_VARS["old_email"] != $HTTP_POST_VARS["email"]
		     && email_exists($HTTP_POST_VARS["email"])) {
                	$errors->email = true;
                	$errormsg .= "<li>" . $the_email_address . " <b>" . ov($HTTP_POST_VARS["email"]) ."</b> " . $already_exists;
        	}
*/
		if (empty($errormsg)) {
			update_user($HTTP_POST_VARS);
			print_user_list();
		} else {
			$frm["username"] = $HTTP_POST_VARS["username"];
			$frm["usertype"] = $HTTP_POST_VARS["usertype"];
			$frm["priv"] = $HTTP_POST_VARS["priv"];
			$frm["firstname"] = $HTTP_POST_VARS["firstname"];
			$frm["lastname"] = $HTTP_POST_VARS["lastname"];
			$frm["fiscalcode"] = $HTTP_POST_VARS["fiscalcode"];
			$frm["address"] = $HTTP_POST_VARS["address"];
			$frm["number"] = $HTTP_POST_VARS["number"];
			$frm["city"] = $HTTP_POST_VARS["city"];
			$frm["state"] = $HTTP_POST_VARS["state"];
			$frm["zip_code"] = $HTTP_POST_VARS["zip_code"];
			$frm["phone"] = $HTTP_POST_VARS["phone"];
			$frm["fax"] = $HTTP_POST_VARS["fax"];
			$frm["mobilephone"] = $HTTP_POST_VARS["mobilephone"];
			$frm["email"] = $HTTP_POST_VARS["email"];
			$frm["old_email"] = $HTTP_POST_VARS["old_email"];
			$frm["authdata"] = $HTTP_POST_VARS["authdata"];
			$frm["acceptadvert"] = $HTTP_POST_VARS["acceptadvert"];
			$frm["notes"] = $HTTP_POST_VARS["notes"];
			$frm["ournotes"] = $HTTP_POST_VARS["ournotes"];
			$frm["newmode"] = "update";
			$frm["submit_caption"] = $Save_Changes;
			include("$CFG->templatedir"."form_header.ihtml");
			include("templates/user_form-".$HTTP_POST_VARS["usertype"].".ihtml");
		}
		break;

	case "resetpw" :
		$return = reset_user_password($username);
		if ($return == 0) {
			include("templates/".$SESSION["lang"]."/user_password_reset.ihtml");
		} else {
			include("templates/".$SESSION["lang"]."/password_not_reset.ihtml");
		}
		print_user_list();
		break;

	case "import" :
		print_import_users_form();
		break;

	case "update_imp" :
		if ($userfile == 'none')
			print_import_users_form();
		else
			import_users($userfile);
		break;

	default :
		$SESSION["goback"]["request_uri"] = $REQUEST_URI;
		$SESSION["goback"]["query_string"] = $QUERY_STRING;
		print_user_list();
		break;
}

include("templates/footer.ihtml");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function show_user_details($username) {

	global $CFG, $ME;
	global $SESSION;
	include ($CFG->global);

	$qid = db_query("
	SELECT * FROM users WHERE username = '$username'
	");
	$frm = db_fetch_array($qid, 0);

	include("templates/user_details-".$frm["usertype"].".ihtml");
}

function print_add_user_form($usertype) {
/* print a blank user form so we can add a new user */

	global $CFG, $ME;
	global $SESSION;
	global $page_number, $dbchanged;
	global $yes;
	include ($CFG->global);

	/* set default values for the reset of the fields */
	$frm["username"] = "";
	$frm["firstname"] = "";
	$frm["lastname"] = "";
	$frm["address"] = "";
	$frm["number"] = "";
	$frm["city"] = "";
	$frm["state"] = "";
	$frm["zip_code"] = "";
	$frm["phone"] = "";
	$frm["fax"] = "";
	$frm["mobilephone"] = "";
	$frm["email"] = "";
	$frm["authdata"] = "";
	$frm["acceptadvert"] = $yes;
	$frm["notes"] = "";

	$frm["newmode"] = "insert";
	$frm["submit_caption"] = $Add_User;

	include("templates/user_form-".$usertype.".ihtml");
}

function print_edit_user_form($username) {
/* print a user form so we can edit the selected user */

	global $CFG, $ME;
	global $SESSION;
	global $page_number, $dbchanged;
	global $yes;
	include ($CFG->global);

	/* load up the information for the user */
	$qid = db_query("
	SELECT * FROM users WHERE username = '$username'
	");
	$frm = db_fetch_array($qid, 0);
	$frm["old_email"] = $frm["email"];

	$frm["newmode"] = "update";
	$frm["submit_caption"] = $Save_Changes;

	include("templates/user_form-".$frm["usertype"].".ihtml");
}

function delete_user($username) {
/* delete the user who's login is $username */

	global $CFG, $ME;
	global $SESSION;
	include ($CFG->global);

	$qid = db_query("SELECT priv FROM users WHERE username = '$username'");
	$user = db_fetch_object($qid, 0);
	if ($user->priv != "admin") {
		$qid = db_query("DELETE FROM users WHERE username = '$username'");
		include("templates/user_deleted.ihtml");
	} else {
		include("templates/".$SESSION["lang"]."/admin_not_deleted.ihtml");
	}
}

function insert_user($frm) {
/* add a user into the database, we should really have some good validation
 * routines to check for things like bad passwords, etc., but for the purpose
 * of this tutorial it's left to the reader (you) to add them in :) */

	global $CFG, $SESSION;
	global $myday, $mymonth;
	include ($CFG->global);

	$date = $myday[date("w")] . date(" j") . "-" . date("n") . "-" . date("Y H:i:s");
	$fromip = getenv("REMOTE_ADDR");

	$password = generate_password();

	$qid = db_query("
	INSERT INTO users (
		username, password, usertype, priv, firstname, lastname,
		fiscalcode, address, number, city, state, zip_code,
		phone, fax, mobilephone, email,
		authdata, acceptadvert, notes, ournotes, date, fromip
	) VALUES (
		 '$frm[username]'
		,'" . md5($password) ."'
		,'$frm[usertype]'
		,'$frm[priv]'
		,'$frm[firstname]'
		,'$frm[lastname]'
		,'$frm[fiscalcode]'
		,'$frm[address]'
		,'$frm[number]'
		,'$frm[city]'
		,'$frm[state]'
		,'$frm[zip_code]'
		,'$frm[phone]'
		,'$frm[fax]'
		,'$frm[mobilephone]'
		,'$frm[email]'
		,'$frm[authdata]'
		,'$frm[acceptadvert]'
		,'$frm[notes]'
		,'$frm[ournotes]'
		,'$date'
		,'$fromip'
	)");

	include("templates/user_added.ihtml");
}

function update_user($frm) {
/* update the user record in the database */

	global $CFG, $SESSION;
	global $username;
	include ($CFG->global);

	$qid = db_query("
	UPDATE users SET
		 priv = '$frm[priv]'
		,firstname = '$frm[firstname]'
		,lastname = '$frm[lastname]'
		,fiscalcode = '$frm[fiscalcode]'
		,address = '$frm[address]'
		,number = '$frm[number]'
		,city = '$frm[city]'
		,state = '$frm[state]'
		,zip_code = '$frm[zip_code]'
		,phone = '$frm[phone]'
		,fax = '$frm[fax]'
		,mobilephone = '$frm[mobilephone]'
		,email = '$frm[email]'
		,authdata = '$frm[authdata]'
		,acceptadvert = '$frm[acceptadvert]'
		,notes = '$frm[notes]'
		,ournotes = '$frm[ournotes]'
	WHERE username = '$frm[username]'
	");
	include("templates/user_updated.ihtml");
}

function print_user_list() {
/* read all the categories from the database and print them into a table.  we
 * will use a template to display the listings to keep this main script clean */

	global $CFG, $ME;
	global $SESSION;
	global $page_number, $dbchanged;
	include ($CFG->global);

	if (!isset($page_number) || $dbchanged) {
		$qid = db_query("
		SELECT username, firstname, lastname, phone, email, authdata, acceptadvert
		FROM users
		WHERE username <> 'root'
		ORDER BY username ASC
  		");

		$SESSION["numr"] = db_num_rows($qid);
		for ($i=0; $i<$SESSION["numr"]; $i++) {
			$SESSION["users"][$i] = db_fetch_array($qid, $i);
		}
		if (!isset($page_number)) {
			$page_number = 1;
		}
	}

	if ($SESSION["numr"] > $SESSION["users_per_page"]) {
		$first = ($page_number-1)*$SESSION["users_per_page"];
		$last = $SESSION["numr"] < $page_number*$SESSION["users_per_page"] ? $SESSION["numr"]-1 : $page_number*$SESSION["users_per_page"]-1;
		$num_pages = $SESSION["numr"] / $SESSION["users_per_page"];
		if (!($num_pages == (integer) $num_pages)) {
			$num_pages = (integer) $num_pages + 1;
		}
	} else {
		$first = 0;
		$last = $SESSION["numr"] - 1;
	}

	include("templates/user_list.ihtml");
}

function print_import_users_form() {
/* print the import users form so we can add/update users from a text file */
	global $CFG, $ME, $SESSION;
	include ($CFG->global);

	/* set values for the form */
	$frm["submit_caption"] = $Import_Button_Label;
	$frm["newmode"] = "update_imp";

	include("templates/data_import.ihtml");
}

function import_users($userfile) {
/* Import users from a text file */
	global $CFG, $ME, $SESSION;
	include ($CFG->global);

	/* Let's open a transaction */
	$qid = db_begin();

	$fcontents = file ($userfile);
	/* Traverse the file */
	while (list ($line_num, $line) = each ($fcontents)) {
		// Microsoft Stupidity Suppression
		$line = ereg_replace(chr(13), "", $line);
//		$fldarr = split("\",\"",ereg_replace("^\"|\"..$|\".$","",$line));
		$fldarr = split("\t",ereg_replace("\n$","",$line));
//echo "<b>" . $line_num . "</b>:" . $line . "<br>";
		/* Stripping dangerous characters from fields */
		$fldarr[0] = ereg_replace("\'","",$fldarr[0]);
		$fldarr[1] = ereg_replace("\'","",$fldarr[1]);
		$fldarr[2] = ereg_replace("\'","",$fldarr[2]);
		$fldarr[3] = ereg_replace("\'","",$fldarr[3]);
//		$fldarr[4] = ereg_replace("\'","",$fldarr[4]);
		$fldarr[4] = ereg_replace("'","\'",$fldarr[4]);
		$fldarr[4] = ereg_replace("\"","\\\"",$fldarr[4]);
//		$fldarr[5] = ereg_replace("\'","",$fldarr[5]);
		$fldarr[5] = ereg_replace("'","\'",$fldarr[5]);
		$fldarr[5] = ereg_replace("\"","\\\"",$fldarr[5]);
		$fldarr[6] = ereg_replace("\'","",$fldarr[6]);
//		$fldarr[7] = ereg_replace("\'","",$fldarr[7]);
		$fldarr[7] = ereg_replace("'","\'",$fldarr[7]);
		$fldarr[7] = ereg_replace("\"","\\\"",$fldarr[7]);
		$fldarr[8] = ereg_replace("\'","",$fldarr[8]);
//		$fldarr[9] = ereg_replace("\'","",$fldarr[9]);
		$fldarr[9] = ereg_replace("'","\'",$fldarr[9]);
		$fldarr[9] = ereg_replace("\"","\\\"",$fldarr[9]);
//		$fldarr[10] = ereg_replace("\'","",$fldarr[10]);
		$fldarr[10] = ereg_replace("'","\'",$fldarr[10]);
		$fldarr[10] = ereg_replace("\"","\\\"",$fldarr[10]);
		$fldarr[11] = ereg_replace("\'","",$fldarr[11]);
		$fldarr[12] = ereg_replace("\'","",$fldarr[12]);
		$fldarr[13] = ereg_replace("\'","",$fldarr[13]);
		$fldarr[14] = ereg_replace("\'","",$fldarr[14]);
		$fldarr[15] = ereg_replace("\'","",$fldarr[15]);
		$fldarr[16] = ereg_replace("\'","",$fldarr[16]);
		$fldarr[17] = ereg_replace("\'","",$fldarr[17]);
//		$fldarr[18] = ereg_replace("\'","",$fldarr[18]);
		$fldarr[18] = ereg_replace("'","\'",$fldarr[18]);
		$fldarr[18] = ereg_replace("\"","\\\"",$fldarr[18]);
//		$fldarr[19] = ereg_replace("\'","",$fldarr[19]);
		$fldarr[19] = ereg_replace("'","\'",$fldarr[19]);
		$fldarr[19] = ereg_replace("\"","\\\"",$fldarr[19]);
		$fldarr[20] = ereg_replace("\'","",$fldarr[20]);
		$fldarr[21] = ereg_replace("\'","",$fldarr[21]);

		/* Let's see if the user already exists ... */
		$qid = db_query("
		SELECT username FROM users WHERE username = '$fldarr[0]'
		");
		if (db_num_rows($qid) == 0) {
			/* ... if it doesn't exist let's create it in the users table ... */
			$qid = db_query("
			INSERT INTO users (
				username, password, usertype, priv, firstname, lastname,
				fiscalcode, address, number, city, state, zip_code,
				phone, fax, mobilephone, email,
				authdata, acceptadvert, notes, ournotes, date, fromip
			) VALUES (
		 		'$fldarr[0]'
				,'" . md5($fldarr[1]) ."'
				,'$fldarr[2]'
				,'$fldarr[3]'
				,'$fldarr[4]'
				,'$fldarr[5]'
				,'$fldarr[6]'
				,'$fldarr[7]'
				,'$fldarr[8]'
				,'$fldarr[9]'
				,'$fldarr[10]'
				,'$fldarr[11]'
				,'$fldarr[12]'
				,'$fldarr[13]'
				,'$fldarr[14]'
				,'$fldarr[15]'
				,'$fldarr[16]'
				,'$fldarr[17]'
				,'$fldarr[18]'
				,'$fldarr[19]'
				,'$fldarr[20]'
				,'$fldarr[21]'
			)");
		}
		else {
			/* ... otherwise let's update it in the products table ... */
			$qid = db_query("
			UPDATE users SET
				usertype = '$fldarr[2]'
				,priv = '$fldarr[3]'
				,firstname = '$fldarr[4]'
				,lastname = '$fldarr[5]'
				,fiscalcode = '$fldarr[6]'
				,address = '$fldarr[7]'
				,number = '$fldarr[8]'
				,city = '$fldarr[9]'
				,state = '$fldarr[10]'
				,zip_code = '$fldarr[11]'
				,phone = '$fldarr[12]'
				,fax = '$fldarr[13]'
				,mobilephone = '$fldarr[14]'
				,email = '$fldarr[15]'
				,authdata = '$fldarr[16]'
				,acceptadvert = '$fldarr[17]'
				,notes = '$fldarr[18]'
				,ournotes = '$fldarr[19]'
				,date = '$fldarr[20]'
				,fromip = '$fldarr[21]'
			WHERE username = '$fldarr[0]'
			");
		}
	}

	/* Let's close the transaction */
	$qid = db_commit();
	
	/* The End */
	include("templates/data_import_end.ihtml");

}

?>
