<?
/* products.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi (pratesi@telug.it) */
/* (c) 2000 Fabio Molinari (fabio.m@mclink.it) */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include("../application.inc.php");
require_login();
require_priv("admin");

$DOC_TITLE = $Products_Management;
include("templates/header.ihtml");

switch (nvl($mode)) {
	case "add" :
		print_add_product_form(nvl($category_id, 1));
		break;

	case "edit" :
		print_edit_product_form($product_id);
		break;

	case "del" :
		delete_product($product_id);
//		print_product_list();
		break;

	case "insert" :
		$errors = new Object;
		$errormsg = "";
		validate_product_id($HTTP_POST_VARS["product_id"], &$errors, &$errormsg);
		product_id_exists($HTTP_POST_VARS["product_id"], &$errors, &$errormsg);
		validate_product_name($HTTP_POST_VARS["name"], &$errors, &$errormsg);
		validate_price($HTTP_POST_VARS["price"], &$errors, &$errormsg);
		validate_discount($HTTP_POST_VARS["discount"], $HTTP_POST_VARS["discqty"], &$errors, &$errormsg);
		validate_weight($HTTP_POST_VARS["weight"], &$errors, &$errormsg);
		validate_on_special($HTTP_POST_VARS["on_special"], &$errors, &$errormsg);
		validate_product_description($HTTP_POST_VARS["description"], &$errors, &$errormsg);
		validate_product_extended_description($HTTP_POST_VARS["extended_description"], &$errors, &$errormsg);
		if (empty($errormsg)) {
			insert_product($HTTP_POST_VARS, $HTTP_POST_FILES);
//			print_product_list();
		} else {
			$frm["newmode"] = "insert";
			$frm["categories"] = $HTTP_POST_VARS["categories"];
			$frm["product_id"] = $HTTP_POST_VARS["product_id"];
			$frm["name"] = $HTTP_POST_VARS["name"];
			$frm["price"] = $HTTP_POST_VARS["price"];
			if ($SESSION["brand_used"]) {
				// load up all the brands
				$qid = db_query("SELECT id, name FROM brands");
				$frm["brands"] = array();
				$numr = db_num_rows($qid);
				$frm["numbrands"] = $numr;
				for ($i=0; $i<$numr; $i++) {
					$brand = db_fetch_object($qid, $i);
					$frm["brand"][$i]["id"] = $brand->id;
					$frm["brand"][$i]["name"] = $brand->name;
				}
				$frm["brand_id"] = $HTTP_POST_VARS["brand_id"];
			}
			if ($SESSION["iva_used"]) {
				// load up all the iva percentuals
				$qid = db_query("SELECT id, iva FROM iva ORDER BY iva");
				$frm["iva"] = array();
				$numr = db_num_rows($qid);
				$frm["numivavalues"] = $numr;
				for ($i=0; $i<$numr; $i++) {
					$iva = db_fetch_object($qid, $i);
					$frm["iva"][$i]["id"] = $iva->id;
					$frm["iva"][$i]["iva"] = $iva->iva;
				}
				$frm["iva_id"] = $HTTP_POST_VARS["iva_id"];
			}
			$frm["discount"] = $HTTP_POST_VARS["discount"];
			$frm["discqty"] = $HTTP_POST_VARS["discqty"];
			$frm["weight"] = $HTTP_POST_VARS["weight"];
			$frm["on_special"] = $HTTP_POST_VARS["on_special"];
			$frm["description"] = $HTTP_POST_VARS["description"];
			$frm["extended_description"] = $HTTP_POST_VARS["extended_description"];
			$frm["submit_caption"] = $Add_Product;
			/* build the categories listbox options, preselect the top item */
			build_category_tree($category_options, $frm["categories"]);
			include("$CFG->templatedir"."form_header.ihtml");
			include("templates/product_form.ihtml");
		}
		break;

	case "update" :
		$errors = new Object;
		$errormsg = "";
		validate_product_id($HTTP_POST_VARS["product_id"], &$errors, &$errormsg);
		if ($HTTP_POST_VARS["old_product_id"] != $HTTP_POST_VARS["product_id"]) {
			product_id_exists($HTTP_POST_VARS["product_id"], &$errors, &$errormsg);
		}
		validate_on_special($HTTP_POST_VARS["on_special"], &$errors, &$errormsg);
		validate_product_name($HTTP_POST_VARS["name"], &$errors, &$errormsg);
		validate_price($HTTP_POST_VARS["price"], &$errors, &$errormsg);
		validate_discount($HTTP_POST_VARS["discount"], $HTTP_POST_VARS["discqty"], &$errors, &$errormsg);
		validate_weight($HTTP_POST_VARS["weight"], &$errors, &$errormsg);
		validate_product_description($HTTP_POST_VARS["description"], &$errors, &$errormsg);
		validate_product_extended_description($HTTP_POST_VARS["extended_description"], &$errors, &$errormsg);
		if (empty($errormsg)) {
			update_product($HTTP_POST_VARS, $HTTP_POST_FILES);
//			print_product_list();
		} else {
			$frm["newmode"] = "update";
			$frm["categories"] = $HTTP_POST_VARS["categories"];
			$frm["old_product_id"] = $HTTP_POST_VARS["old_product_id"];
			$frm["product_id"] = $HTTP_POST_VARS["product_id"];
			$frm["name"] = $HTTP_POST_VARS["name"];
			$frm["price"] = $HTTP_POST_VARS["price"];
			if ($SESSION["brand_used"]) {
				// load up all the brands
				$qid = db_query("SELECT id, name FROM brands");
				$frm["brands"] = array();
				$numr = db_num_rows($qid);
				$frm["numbrands"] = $numr;
				for ($i=0; $i<$numr; $i++) {
					$brand = db_fetch_object($qid, $i);
					$frm["brand"][$i]["id"] = $brand->id;
					$frm["brand"][$i]["name"] = $brand->name;
				}
				$frm["brand_id"] = $HTTP_POST_VARS["brand_id"];
			}
			if ($SESSION["iva_used"]) {
				// load up all the iva percentuals
				$qid = db_query("SELECT id, iva FROM iva ORDER BY iva");
				$frm["iva"] = array();
				$numr = db_num_rows($qid);
				$frm["numivavalues"] = $numr;
				for ($i=0; $i<$numr; $i++) {
					$iva = db_fetch_object($qid, $i);
					$frm["iva"][$i]["id"] = $iva->id;
					$frm["iva"][$i]["iva"] = $iva->iva;
				}
				$frm["iva_id"] = $HTTP_POST_VARS["iva_id"];
			}
			$frm["discount"] = $HTTP_POST_VARS["discount"];
			$frm["discqty"] = $HTTP_POST_VARS["discqty"];
			$frm["weight"] = $HTTP_POST_VARS["weight"];
			$frm["on_special"] = $HTTP_POST_VARS["on_special"];
			$frm["description"] = $HTTP_POST_VARS["description"];
			$frm["extended_description"] = $HTTP_POST_VARS["extended_description"];
			$frm["submit_caption"] = $Save_Changes;
			/* build the categories listbox options, preselect the top item */
			build_category_tree($category_options, $frm["categories"]);
			include("$CFG->templatedir"."form_header.ihtml");
			include("templates/product_form.ihtml");
		}
		break;

	case "details" :
		print_details_product($product_id);
		break;

	case "import" :
		print_import_products_form();
		break;

	case "update_imp" :
		if ($HTTP_POST_FILES['userfile']['tmp_name'] == "none")
			print_import_products_form();
		else
			import_products($HTTP_POST_FILES);
		break;

	case "imgimport" :
		print_import_images_form();
		break;

	case "update_impimg" :
		if ($HTTP_POST_FILES['userfile']['tmp_name'] == "none")
			print_import_images_form();
		else
			import_images($HTTP_POST_FILES);
		break;

	default :
		$SESSION["goback"]["request_uri"] = $REQUEST_URI;
		$SESSION["goback"]["query_string"] = $QUERY_STRING;
		print_product_list();
		break;
}

include("templates/footer.ihtml");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function print_add_product_form($category_id = 1) {
/* print a blank product form so we can add a new product */

	global $CFG, $ME;
	global $SESSION;
	global $weightunity;
	include ($CFG->global);

	/* set default values for the reset of the fields */
	$frm["categories"] = array($category_id);
	$frm["newmode"] = "insert";
	$frm["name"] = "";
	$frm["brand_id"] = "";
	$frm["price"] = "";
	$frm["iva_id"] = "";
	$frm["discount"] = "";
	$frm["discqty"] = "";
	$frm["weight"] = "";
	$frm["on_special"] = "";
	$frm["description"] = "";
	$frm["extended_description"] = "";
	$frm["submit_caption"] = $Add_Product;

	if ($SESSION["brand_used"]) {
		// load up all the brands
		$qid = db_query("SELECT id, name FROM brands");
		$frm["brands"] = array();
		$numr = db_num_rows($qid);
		$frm["numbrands"] = $numr;
		for ($i=0; $i<$numr; $i++) {
			$brand = db_fetch_object($qid, $i);
			$frm["brand"][$i]["id"] = $brand->id;
			$frm["brand"][$i]["name"] = $brand->name;
		}
	}

	if ($SESSION["iva_used"]) {
		// load up all the iva percentuals
		$qid = db_query("SELECT id, iva FROM iva ORDER BY iva");
		$frm["iva"] = array();
		$numr = db_num_rows($qid);
		$frm["numivavalues"] = $numr;
		for ($i=0; $i<$numr; $i++) {
			$iva = db_fetch_object($qid, $i);
			$frm["iva"][$i]["id"] = $iva->id;
			$frm["iva"][$i]["iva"] = $iva->iva;
		}
	}

	/* build the categories listbox options, preselect the top item */
	build_category_tree($category_options, $frm["categories"]);

	include("templates/product_form.ihtml");
}

function print_edit_product_form($product_id) {
/* print a product form so we can edit the selected product */

	global $CFG, $ME;
	global $SESSION;
	global $weightunity;
	include ($CFG->global);

	/* load up the information for the product */
	$qid = db_query("SELECT * FROM products WHERE id = '$product_id'");
	$frm = db_fetch_array($qid, 0);
	$frm["old_product_id"] = $product_id;
	$frm["old_imagetype"] = $frm["imagetype"];
	$frm["old_imagewidth"] = $frm["imagewidth"];
	$frm["old_imageheight"] = $frm["imageheight"];
	$frm["old_thumbwidth"] = $frm["thumbwidth"];
	$frm["old_thumbheight"] = $frm["thumbheight"];
	$frm["product_id"] = $product_id;

	if($SESSION["brand_used"]) {
		// load up all the brands
		$qid = db_query("SELECT id, name FROM brands");
		$frm["brands"] = array();
		$numr = db_num_rows($qid);
		$frm["numbrands"] = $numr;
		for ($i=0; $i<$numr; $i++) {
			$brand = db_fetch_object($qid, $i);
			$frm["brand"][$i]["id"] = $brand->id;
			$frm["brand"][$i]["name"] = $brand->name;
		}
	}

	if ($SESSION["iva_used"]) {
		// load up all the iva percentuals
		$qid = db_query("SELECT id, iva FROM iva ORDER BY iva");
		$frm["iva"] = array();
		$numr = db_num_rows($qid);
		$frm["numivavalues"] = $numr;
		for ($i=0; $i<$numr; $i++) {
			$iva = db_fetch_object($qid, $i);
			$frm["iva"][$i]["id"] = $iva->id;
			$frm["iva"][$i]["iva"] = $iva->iva;
		}
	}

	/* load up the categories for the product */
	$qid = db_query("
	SELECT category_id
	FROM products_categories
	WHERE product_id = '$product_id'
	");

	$frm["categories"] = array();
	$numr = db_num_rows($qid);
	for ($i=0; $i<$numr; $i++) {
		$cat = db_fetch_object($qid, $i);
		$frm["categories"][] = $cat->category_id;
	}

	/* set values for the form */
	$frm["newmode"] = "update";
	$frm["submit_caption"] = $Save_Changes;

	/* build the categories listbox options, preselect the selected item */
	build_category_tree($category_options, $frm["categories"]);

	include("templates/product_form.ihtml");
}

function print_details_product($product_id) {
/* print a product form so we can edit the selected product */

	global $CFG, $ME;
	global $SESSION;
	global $special_th;
	global $weightunity;
	include ($CFG->global);

	/* load up the information for the product */
	$qid = db_query("SELECT * FROM products WHERE id = '$product_id'");
	$frm = db_fetch_array($qid, 0);

	/* load up the categories for the product */
	$qid = db_query("
	SELECT category_id
	FROM products_categories
	WHERE product_id = '$product_id'
	");

	$frm["categories"] = array();
	$numr = db_num_rows($qid);
	for ($i=0; $i<$numr; $i++) {
		$cat = db_fetch_object($qid, $i);
		$frm["categories"][] = $cat->category_id;
	}

	/* set values for the form */
	$frm["newmode"] = "update";
	$frm["submit_caption"] = $Save_Changes;

	/* build the categories listbox options, preselect the selected item */
	build_category_tree($category_options, $frm["categories"]);

	include("templates/product_details.ihtml");
}

function delete_product($product_id) {
/* delete the product specified by $product_id, we have to delete the product and then
 * the appropriate entries from the products_categories table.  this should be
 * wrapped inside a transaction, unfortunately MySQL currently does not support
 * transactions. */

	global $CFG, $ME;
	global $SESSION;
	include ($CFG->global);

	$qid = db_begin();

	/* load up the information for the product */
	$qid = db_query("
	SELECT imagetype
	FROM products
	WHERE id = '$product_id'
	");
	$prod = db_fetch_object($qid, 0);

	/* delete this product */
	$qid = db_query("
	DELETE FROM products
	WHERE id = '$product_id'
	");

// Remove the product image
	if ($prod->imagetype != "") {
		$upload_path = $CFG->productsdir;
		$upload_name = $upload_path.string_cleanup($product_id);
		$upload_name_thumb = $upload_name.".thumb.jpg";
		$upload_name .= ".".$prod->imagetype;
		system ("rm -f $upload_name $upload_name_thumb", $result);
	}

	/* delete this product from the products_categories table */
	$qid = db_query("
	DELETE FROM products_categories
	WHERE product_id = '$product_id'
	");

	$qid = db_commit();

	include("templates/product_deleted.ihtml");
}

function insert_product($frm, $HTTP_POST_FILES) {
/* add a new product.  all the fields that we want are
 * going to in the variable $frm */

	global $CFG, $ME, $SESSION;
	include ($CFG->global);

	if ($HTTP_POST_FILES['userfile']['tmp_name'] == "none") {
		$type = "";
		echo "<div class=normal>" . $no_product_image_chosen . "</div>";
	} else {
		$size = getimagesize ($HTTP_POST_FILES['userfile']['tmp_name']);
		switch ($size[2]) {
			case 1 :
				$type = "gif";
				$convert = "giftopnm";
				break;
			case 2 :
				$type = "jpg";
				$convert = "djpeg";
				break;
			case 3 :
				$type = "png";
				$convert = "pngtopnm";
				break;
			default:
				$type = "";
				echo "<div class=warning>" . $unsupported_image_type . "</div>";
		}
		if ($type != "") {
			$upload_path = $CFG->productsdir;
			$upload_name = $upload_path.string_cleanup($frm[product_id]);
			$upload_thumb_name = $upload_name.".thumb.jpg";
			$upload_name .= ".".$type;
			system("$CFG->pnmpath/$convert ".$HTTP_POST_FILES['userfile']['tmp_name']." | ".
				"$CFG->pnmpath/pnmscale -xysize 100 80 | ".
				"$CFG->pnmpath/cjpeg -optimize -progressive -quality 85 > ".
				$upload_thumb_name, $result);
			$thumbsize = getimagesize ($upload_thumb_name);
			if (!copy($HTTP_POST_FILES['userfile']['tmp_name'],$upload_name)) {
				echo "<div class=warning>" . $image_upload_failed . "</div>";
			} else {
				system ("chmod 644 $upload_name", $result);
			}
		}
	}

	$qid = db_begin();

	/* add the product into the products table */
	if ($frm[extended_description] == "")
		$frm[extended_description] = $frm[description];
	while (list($key, $val) = each($frm)){
		if (is_string($val)) $frm[$key] = addslashes($val);
	}
	$qid = db_query("
	INSERT INTO products (id, name, brand_id, price, iva_id, discount, discqty, weight, on_special, description, extended_description, imagetype, imagewidth, imageheight, thumbwidth, thumbheight)
	VALUES ('$frm[product_id]', '$frm[name]', '$frm[brand_id]', '$frm[price]', '$frm[iva_id]', '$frm[discount]', '$frm[discqty]', '$frm[weight]', '$frm[on_special]', '$frm[description]', '$frm[extended_description]', '$type', '$size[0]', '$size[1]', '$thumbsize[0]', '$thumbsize[1]')
	");

	/* add this product under the specified categories */
	for ($i = 0; $i < count($frm["categories"]); $i++) {
		$qid = db_query("
		INSERT INTO products_categories (category_id, product_id)
		VALUES ('{$frm["categories"][$i]}', '$frm[product_id]')
		");
	}

	$qid = db_commit();

	include("templates/product_added.ihtml");
}

function update_product($frm, $HTTP_POST_FILES) {
/* update a product with new values.  all the fields that we want are
 * going to in the variable $frm */

	global $CFG, $ME;
	global $SESSION;
	include ($CFG->global);

	$type = $frm["old_imagetype"];
	$imagewidth = $frm["old_imagewidth"];
	$imageheight = $frm["old_imageheight"];
	$thumbwidth = $frm["old_thumbwidth"];
	$thumbheight = $frm["old_thumbheight"];

/* does PHP 4.0.4pl1 have a bug causing $HTTP_POST_FILES['userfile']['type'] == "" ?
echo ";".$HTTP_POST_FILES['userfile']['name'].";";
echo     $HTTP_POST_FILES['userfile']['tmp_name'].";";
echo     $HTTP_POST_FILES['userfile']['size'].";";
echo     $HTTP_POST_FILES['userfile']['type'].";";
echo "<br><br>";
foreach($HTTP_POST_FILES['userfile'] as $k => $v) {
	echo "\$HTTP_POST_FILES['userfile'][$k] => ;$v;";
	echo "<br>";
}
*/

	if ($HTTP_POST_FILES['userfile']['tmp_name'] == "none") {
		echo "<div class=normal>" . $no_product_image_chosen . "</div>";
		if ($frm[old_product_id] != $frm[product_id] && $frm["old_imagetype"] != "") {
			$upload_path = $CFG->productsdir;
			$old_upload_name = $upload_path.string_cleanup($frm[old_product_id]);
			$upload_name = $upload_path.string_cleanup($frm[product_id]);
			$old_upload_name_thumb = $old_upload_name.".thumb.jpg";
			$upload_name_thumb = $upload_name.".thumb.jpg";
			rename ($old_upload_name_thumb, $upload_name_thumb);
			$old_upload_name .= ".".$frm["old_imagetype"];
			$upload_name .= ".".$frm["old_imagetype"];
			rename ($old_upload_name, $upload_name);
		}
	} else {
		$size = getimagesize ($HTTP_POST_FILES['userfile']['tmp_name']);
		switch ($size[2]) {
			case 1 :
				$newtype = "gif";
				$convert = "giftopnm";
				break;
			case 2 :
				$newtype = "jpg";
				$convert = "djpeg";
				break;
			case 3 :
				$newtype = "png";
				$convert = "pngtopnm";
				break;
			default:
				$newtype = "";
				echo "<div class=warning>" . $unsupported_image_type . "</div>";
		}
		if ($newtype != "") {
			$upload_path = $CFG->productsdir;
			$upload_name = $upload_path.string_cleanup($frm[product_id]);
			$upload_thumb_name = $upload_name.".thumb.jpg";
			$upload_name .= ".".$newtype;
			$type = $newtype;
			$imagewidth = $size[0];
			$imageheight = $size[1];
			system("$CFG->pnmpath/$convert ".$HTTP_POST_FILES['userfile']['tmp_name']." | ".
				"$CFG->pnmpath/pnmscale -xysize 100 80 | ".
				"$CFG->pnmpath/cjpeg -optimize -progressive -quality 85 > ".
				$upload_thumb_name, $result);
			$thumbsize = getimagesize ($upload_thumb_name);
			$thumbwidth = $thumbsize[0];
			$thumbheight = $thumbsize[1];
			if (!copy($HTTP_POST_FILES['userfile']['tmp_name'],$upload_name)) {
				echo "<div class=warning>" . $image_upload_failed . "</div>";
			} else {
				system ("chmod 644 $upload_name", $result);
			}
			if ($frm["old_imagetype"] != "" && ($frm[old_product_id] != $frm[product_id] || $frm["old_imagetype"] != $newtype)) {
				$upload_path = $CFG->productsdir;
				$old_upload_name = $upload_path.string_cleanup($frm[old_product_id]);
				if ($frm[old_product_id] != $frm[product_id]) {
					$old_upload_name_thumb = $old_upload_name.".thumb.jpg";
					system ("rm -f $old_upload_name_thumb", $result);
				}
				$old_upload_name .= ".".$frm["old_imagetype"];
				system ("rm -f $old_upload_name", $result);
			}
		}
	}

	$qid = db_begin();

	/* update the products table with the new information */
	if ($frm[extended_description] == "")
		$frm[extended_description] = $frm[description];
	while (list($key, $val) = each($frm)){
		if (is_string($val)) $frm[$key] = addslashes($val);
	}
	$qid = db_query("
	UPDATE products SET
	 	 id = '$frm[product_id]'
		,name = '$frm[name]'
		,brand_id = '$frm[brand_id]'
		,price = '$frm[price]'
		,iva_id = '$frm[iva_id]'
		,discount = '$frm[discount]'
		,discqty = '$frm[discqty]'
		,weight = '$frm[weight]'
		,on_special = '$frm[on_special]'
		,description = '$frm[description]'
		,extended_description = '$frm[extended_description]'
		,imagetype = '$type'
		,imagewidth = '$imagewidth'
		,imageheight = '$imageheight'
		,thumbwidth = '$thumbwidth'
		,thumbheight = '$thumbheight'
	WHERE id = '$frm[old_product_id]'
	");

	/* delete all the categories this product was associated with */
	$qid = db_query("
	DELETE FROM products_categories
	WHERE product_id = '$frm[old_product_id]'
	");

	/* add associations for all the categories this product belongs to, if
 	* no categories were selected, we will make it belong to the top
 	* category */
	if (count($frm["categories"]) == 0) {
		$frm["categories"][] = 1;
	}

	for ($i = 0; $i < count($frm["categories"]); $i++) {
		$qid = db_query("
		INSERT INTO products_categories (category_id, product_id)
		VALUES ('{$frm["categories"][$i]}', '$frm[product_id]')
		");
	}

	$qid = db_commit();

	include("templates/product_updated.ihtml");
}

function print_product_list() {
/* read all the products from the database and print them into a table.  we
 * will use a template to display the listings to keep this main script clean */

	global $CFG, $ME;
	global $SESSION;
	global $weightunity;
	global $page_number, $dbchanged;
	include ($CFG->global);

	if (!isset($page_number) || $dbchanged) {
		$qid = db_query("
		SELECT p.id AS product_id, p.name, p.brand_id, p.price,
			p.iva_id, p.discount, p.discqty, p.weight,
			p.description, p.extended_description,
			p.imagetype, p.imagewidth, p.imageheight,
			p.thumbwidth, p.thumbheight,
			c.name AS category
		FROM products p, products_categories pc, categories c
		WHERE p.id = pc.product_id
		  	AND c.id = pc.category_id
		ORDER BY c.name
  		");
	
		$SESSION["numr"] = db_num_rows($qid);
		for ($i=0; $i<$SESSION["numr"]; $i++) {
			$SESSION["products"][$i] = db_fetch_array($qid, $i);
		}
		if (!isset($page_number)) {
			$page_number = 1;
		}
	}

	if ($SESSION["numr"] > $SESSION["products_per_page"]) {
		$first = ($page_number-1)*$SESSION["products_per_page"];
		$last = $SESSION["numr"] < $page_number*$SESSION["products_per_page"] ? $SESSION["numr"]-1 : $page_number*$SESSION["products_per_page"]-1;
		$num_pages = $SESSION["numr"] / $SESSION["products_per_page"];
		if (!($num_pages == (integer) $num_pages)) {
			$num_pages = (integer) $num_pages + 1;
		}
	} else {
		$first = 0;
		$last = $SESSION["numr"] - 1;
	}
	include("templates/product_list.ihtml");
}

function print_import_products_form() {
/* print the import products form so we can add/update products from a text file */
	global $CFG, $ME, $SESSION;
	include ($CFG->global);

	/* set values for the form */
	$frm["submit_caption"] = $Import_Button_Label;
	$frm["newmode"] = "update_imp";

	include("templates/data_import.ihtml");
}

function import_products($HTTP_POST_FILES) {
/* Import products from a text file */
	global $CFG, $ME, $SESSION;
	include ($CFG->global);

	/* Let's open a transaction */
	$qid = db_begin();

	$fcontents = file ($HTTP_POST_FILES['userfile']['tmp_name']);
	/* Traverse the file */
	while (list ($line_num, $line) = each ($fcontents)) {
		// Microsoft Stupidity Suppression
		$line = ereg_replace(chr(13), "", $line);
		$fldarr = split("\t",ereg_replace("\n$","",$line));
//echo "<b>" . $line_num . "</b>:" . $line . "<br>";
		/* Stripping dangerous characters from field */
		$fldarr[0] = ereg_replace("\'","",$fldarr[0]);

		/* Let's see if the category exists ... */
		$qid = db_query("
		SELECT id, name FROM categories WHERE name = '$fldarr[0]'
		");
		if (db_num_rows($qid) == 0) {
			/* ... if it doesn't exist let's return an error ... */
			echo $line_num . $Err_ImpCat . $fldarr[0] . "'.<br>";
		} else {
			/* ... otherwise let's save its ID ... */
			$arr = db_fetch_array($qid,0);
			$pid = $arr[0];

			/* Stripping dangerous characters from fields */
			$fldarr[1] = ereg_replace("\'","",$fldarr[1]);
//			$fldarr[2] = ereg_replace("\'","",$fldarr[2]);
			$fldarr[2] = ereg_replace("'","\'",$fldarr[2]);
			$fldarr[2] = ereg_replace("\"","\\\"",$fldarr[2]);
			$fldarr[3] = ereg_replace("\'","",$fldarr[3]);
			if($SESSION["brand_used"]) {
				if ($fldarr[3] == "") {
					// brand not defined, set the brand_id to 0
					$fldarr[3] = 0;
				} else {
					/* Let's see if the brand exists ... */
					$qid = db_query("
					SELECT id FROM brands WHERE name = '$fldarr[3]'
					");
					if (db_num_rows($qid) == 0) {
						/* ... if it doesn't exist let's return an error ... */
						echo $line_num . $Err_ImpBrand . $fldarr[3] . "'.<br>";
						$fldarr[3] = "";
					} else {
						/* ... otherwise let's substitute it with its id */
						$arr = db_fetch_array($qid, 0);
						$fldarr[3] = $arr[0];
					}
				}
			}
			$fldarr[4] = ereg_replace("\'","",$fldarr[4]);
			$fldarr[5] = ereg_replace("\'","",$fldarr[5]);
			if($SESSION["iva_used"]) {
				if ($fldarr[5] == "") {
					// iva not defined, set it to 0 (iva_id = 0)
					$fldarr[5] = 0;
				} else {
					/* Let's see if the iva exists ... */
					$qid = db_query("
					SELECT id FROM iva WHERE iva = '$fldarr[5]'
					");
					if (db_num_rows($qid) == 0) {
						/* ... if it doesn't exist let's return an error ... */
						echo $line_num . $Err_ImpIVA . $fldarr[5] . "'.<br>";
						$fldarr[5] = "";
					} else {
						/* ... otherwise let's substitute it with its id */
						$arr = db_fetch_array($qid, 0);
						$fldarr[5] = $arr[0];
					}
				}
			}
			$fldarr[6] = ereg_replace("\'","",$fldarr[6]);
			$fldarr[7] = ereg_replace("\'","",$fldarr[7]);
			$fldarr[8] = ereg_replace("\'","",$fldarr[8]);
			$fldarr[9] = ereg_replace("\'","",$fldarr[9]);

//			$fldarr[10] = ereg_replace("\'","",$fldarr[10]);
			$fldarr[10] = ereg_replace("'","\'",$fldarr[10]);
			$fldarr[10] = ereg_replace("\"","\\\"",$fldarr[10]);
			$fldarr[11] = ereg_replace("'","\'",$fldarr[11]);
			$fldarr[11] = ereg_replace("\"","\\\"",$fldarr[11]);

			/* ... and let's see if the product already exists ... */
			$qid = db_query("
			SELECT id, name FROM products WHERE id = '$fldarr[6]'
			");
			if (db_num_rows($qid) == 0) {
				/* ... if it doesn't exist let's create it in the products table ... */
				if ($frm[extended_description] == "")
					$frm[extended_description] = $frm[description];
				$qid = db_query("
				INSERT INTO products (id, name, brand_id, price, iva_id, discount, discqty, weight, on_special, description, extended_description)
				VALUES ('$fldarr[1]', '$fldarr[2]', '$fldarr[3]', '$fldarr[4]', '$fldarr[5]', '$fldarr[6]', '$fldarr[7]', '$fldarr[8]', '$fldarr[9]', '$fldarr[10]', '$fldarr[11]')
				");
				/* ... and create it in the products_categories table ... */
				$qid = db_query("
				INSERT INTO products_categories (product_id, category_id)
				VALUES ('$fldarr[1]', '$pid')
				");
			}
			else {
				/* ... otherwise let's update it in the products table ... */
				if ($frm[extended_description] == "")
					$frm[extended_description] = $frm[description];
				$qid = db_query("
				UPDATE products SET
					name = '$fldarr[2]'
		 			,brand_id = '$fldarr[3]'
		 			,price = '$fldarr[4]'
		 			,iva_id = '$fldarr[5]'
					,discount = '$fldarr[6]'
					,discqty = '$fldarr[7]'
					,weight = '$fldarr[8]'
					,on_special = '$fldarr[9]'
					,description = '$fldarr[10]'
					,extended_description = '$fldarr[11]'
				WHERE id = '$fldarr[1]'
				");
				/* ... then, let's see if the product already exists with this category ... */
				$qid = db_query("
				SELECT category_id FROM products_categories WHERE product_id = '$fldarr[1]' AND category_id = '$pid'
				");
				if (db_num_rows($qid) == 0) {
					/* ... if it doesn't exist let's create it in the products_categories table ... */
					$qid = db_query("
					INSERT INTO products_categories (product_id, category_id)
					VALUES ('$fldarr[1]', '$pid')
					");
				}
			}

		}
	}

	/* Let's close the transaction */
	$qid = db_commit();
	
	/* The End */
	include("templates/data_import_end.ihtml");

}

function print_import_images_form() {
/* print the import images form so we can add/update images from a zip file */
	global $CFG, $ME, $SESSION;
	include ($CFG->global);

	/* set values for the form */
	$frm["submit_caption"] = $Import_Images_Button_Label . " (.tar.gz, .tgz, .zip)";
	$frm["newmode"] = "update_impimg";

	include("templates/data_import.ihtml");
}

function import_images($HTTP_POST_FILES) {
/* Import products from a text file */
	global $CFG, $ME, $SESSION;
	include ($CFG->global);
	$upload_path = $CFG->productsdir;

	/* Let's open a transaction */
	$qid = db_begin();

	// Let's unzip the file with images into tempdir ...
//	$tmpdir = get_cfg_var("upload_tmp_dir");
	$tmpdir = $CFG->productsdir . "/tmp/";
	system ("rm -rf $tmpdir", $result);
	system ("mkdir " . $tmpdir, $result);
	system ("unzip -qq ".$HTTP_POST_FILES['userfile']['tmp_name']." -d " . $tmpdir, $result);
	system ("gzip -dc ".$HTTP_POST_FILES['userfile']['tmp_name']." | tar xf - -C " . $tmpdir, $result);
	// Let's manage all files in the tempdir
	$handle=opendir($tmpdir);
//echo "Directory handle: $handle\n";
//echo "Files:\n";
	while ($file = readdir($handle)) {
//echo "$file\n";
//echo strtok($file,'.') . "\n";
		$pid = strtok($file,'.');
		if (!empty($pid)) {
			$appoggio = string_cleanup($pid);
			$upload_name = $upload_path.$appoggio;
			$size = getimagesize ($tmpdir.$file);
			switch ($size[2]) {
				case 1 :
					$type = "gif";
					$convert = "giftopnm";
					break;
				case 2 :
					$type = "jpg";
					$convert = "djpeg";
					break;
				case 3 :
					$type = "png";
					$convert = "pngtopnm";
					break;
				default :
					$type = "";
					echo "<div class=warning>" . $appoggio . ": " . $unsupported_image_type . "</div>";
			}
			if ($type != "") {
				$upload_name_thumb = $upload_name.".thumb.jpg";
				$upload_name_old = $upload_name.".".$oldtype;
				$upload_name .= ".".$type;
				if (!copy($tmpdir.$file, $upload_name)) {
					echo "<div class=normal>" . $image_upload_failed . "</div>";
				} else {
					system ("chmod 644 $upload_name", $result);
					system ("$CFG->pnmpath/$convert ".$upload_name . " | ".
						"$CFG->pnmpath/pnmscale -xysize 100 80 | ".
						"$CFG->pnmpath/cjpeg -optimize -progressive -quality 85 > ".
						$upload_name_thumb, $result);
					$thumbsize = getimagesize ($upload_name_thumb);
// if we are updating a product image and the old imagetype
// is empty or different from the new one, then we remove the old image
					$qid = db_query("SELECT imagetype FROM products WHERE id = '$appoggio'");
					$arr = db_fetch_array($qid, 0);
					$oldtype = $arr["imagetype"];
					if ($type != $oldtype) {
						system ("rm -f ".$upload_name_old, $result);
					}
// ///
					$qid = db_query("
					UPDATE products SET
						 imagetype = '$type'
						,imagewidth = '$size[0]'
						,imageheight = '$size[1]'
						,thumbwidth = '$thumbsize[0]'
						,thumbheight = '$thumbsize[1]'
					WHERE id = '$appoggio'
					");
				}
			}
		}
	}
	closedir($handle); 

	// Let's remove the temporary directory ...
	system ("rm -rf $tmpdir", $result);

	/* Let's close the transaction */
	$qid = db_commit();
	
	/* The End */
	include("templates/data_import_end.ihtml");

}

?>
