/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef INDEXGROUPLISTVIEWITEM_H
#define INDEXGROUPLISTVIEWITEM_H

#include "../../baselistviewitem.h"
#include "../../../dataaccess/tables/indicies/dbindex.h"
#include "../../../dataaccess/dbmastermanagerref.h"

/**
 * This list view item is used to represent an index list.
 */
class IndexGroupListViewItem: public BaseListViewItem, public DBMasterManagerRef
{

protected:
	string m_strTableName;
				
public:
	
	/**
 	 * Constructor
   */		
	IndexGroupListViewItem(QListViewItem *pqoListViewItem);
	IndexGroupListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem);	

	/**
 	 * Used to set the table name.
 	 * @param rstrTableName	the table name
   */			    	
	void setTableName(const string & rstrTableName);

	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	virtual void showRightPressedMenu(const QPoint & rqoLocation, int nColumn);
				
	/**
 	 * Used to create all the first level children of the current item.
   */			    						
	virtual void initChildren();

};


#endif

