/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef SERVERLISTVIEWITEM_H
#define SERVERLISTVIEWITEM_H

#include "baselistviewitem.h"
#include <string>

/**
 * This list view item is used to represent a server item.
 */
class ServerListViewItem: public BaseListViewItem
{

protected:
	// server connection variables
	string m_strServerName;
	int m_nPortNumber;
	bool m_bLocalServer;

public:
	
	/**
 	 * Constructor
   */		
	ServerListViewItem(QListViewItem *pqoListViewItem);
	ServerListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem);	

	/**
	 * This method is used to set the server name (could be IP address as well).
	 */
	void setServerName(const string &rstrServerName);

	/**
	 * This method is used to get the server name (could be IP address as well).
	 */
	const string & getServerName() const;

	/**
	 * This method is used to set the server port number.
	 */
	void setPortNumber(int nPortNumber);

	/**
	 * This method is used to get the port number.
	 */
	int getPortNumber() const;
		
	/**
	 * This method is used to indicate whether this address is local or not.
	 * If the address is set to be local then a local unix socket connection will
	 * be used instead of a TCP connection.
	 */
	void setLocalServer(bool bLocalServer);

	/**
	 * This method is used to indicate whether this address is local or not.
	 * If the address is set to be local then a local unix socket connection will
	 * be used instead of a TCP connection.
	 */
	bool isLocalServer() const;

	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	virtual void showRightPressedMenu(const QPoint & rqoLocation, int nColumn);
		
	/**
 	 * Used to update the description.
   */			    	
	virtual void updateDescription();
	
	/**
 	 * Used to create all the first level children of the current item.
   */			    						
	virtual void initChildren();
		
};


#endif

