/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "openfileexception.h"
	
	/**
 	 * Constructor
 	 *
 	 * @param	rstrFileName	used to indicate the file name that caused the exception
 	 * @param	rstrDescription	used to indicate what the exception was
 	 * @param	rstrClassName		the class that the exception was initially thrown from
 	 * @param	rstrMethodName		the method that the exception was initially thrown from
   */		
	OpenFileException::OpenFileException(const string & rstrFileName, const string &rstrDescription,
			const string &rstrClassName, const string &rstrMethodName)
		: VPSystemException(rstrDescription, rstrClassName, rstrMethodName)
	{
		m_strName = "OpenFileException";
		m_strFileName = rstrFileName;
	} // end constructor
	
	/**
 	 * Copy Constructor
 	 *
 	 * @param	roException			another exception to copy
   */		
	OpenFileException::OpenFileException(const OpenFileException &roException)
		: VPSystemException(roException)
	{
		m_strFileName = roException.m_strFileName;
	} // end copy constructor

	/**
 	 * Assignment operator
 	 *
 	 * @param	roException			another exception to assign from
   */		
	OpenFileException & OpenFileException::operator=(const OpenFileException &roException)
	{
		VPSystemException::operator=(roException);
		m_strFileName = roException.m_strFileName;
		return (*this);
	} // end operator=
				
	/**
	 * This function is used to retrieve the file name.
	 * @return	the file name
	 */
	const string & OpenFileException::getFileName() const
	{
		return m_strFileName;
	} // end getFileName			
	