/*
 * DBObject.java
 *
 * Created on 30 de julio de 2002, 15:27
 */

package pgclibrary.objects;
import pgclibrary.dataaccess.*;
import java.sql.*;

/** This class implements the interface for all
 * database objects that interacts with the database.
 * @author nestor
 */
public abstract class DBObject {
    private DBObject owner = null;
    
    private User creator = null;
    private String name = new String();
    
    /** Creates a new instance of DBObject.
     * @param _owner The owner DBObject for this object.
     */
    public DBObject(DBObject _owner) {
        setOwner(_owner);
    }
    
    /** Returns the SQL string that
     * generate this object.  Its used in SQL scripts generation.
     * @return SQL DML instruction for generation.
     */
    public abstract String getInsertSQL();
    
    /** Retrieve the SQL string that eliminate this object from
     * the database. Used in SQL Script generation.
     * @return SQL DML string.
     */
    public abstract String getDeleteSQL();
    
    
    /** Retrieve the SQL string that eliminate this object from
     * the database.
     * @return SQL DML string.
     */
    public boolean Drop(){
        return false;
    }
    
    /** Initialize all properties
     */
    protected void initialize(){
        name = new String();
    }
    
    /** refresh the data from database.
     * if oid>0. Elsewere no action.
     */
    public abstract void refresh();
    
    public DBObject getOwner(){
        return owner;
    }
    protected void setOwner(DBObject _owner){
        owner = _owner;
    }
    
    protected void setCreator(User _creator){
        creator = _creator;
    }
    public User getCreator(){
        return creator;
    }
    
    public String getName(){
        return name;
    }
    protected void setName(String _name){
        if(_name != null){
            name = _name;
        } else {
            name = new String();
        }
    }
    
    /** Retrieve the MainConnection for database communications.
     * @return MainConnection to inteact.
     */
    public MainConnection getConnection(){
        return getOwner().getConnection();
    }
}
