/*
 * PrincipalFrameComponent.java
 *
 *
 * Created on 18 de julio de 2002, 15:46
 */

package frames;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import components.*;
import pgclibrary.objects.*;
import components.*;
import components.table.*;
import components.group.*;
import components.view.*;
import components.database.*;
import components.sequence.*;
import components.user.*;
import pgclibrary.dataaccess.*;
import components.treeObjects.*;

/**
 *
 * @author  nestor
 */
public class PrincipalFrameComponent extends JSplitPane
{
    private PrincipalFrame frame = null;
    private TreeControl tree_control = null;
    private TreeToolbar tree_toolbar = null;

    private TreeInfo last_selected = null;
    private CreditsPanel default_panel = new CreditsPanel();
    private DatabaseRootPanel dbRootPanel = new DatabaseRootPanel();
    private TablePanel tablePanel = new TablePanel();
    private ViewPanel viewPanel = new ViewPanel();
    private UserPanel userPanel = new UserPanel();
    private GroupPanel groupPanel = new GroupPanel();
    private DatabasePanel databasePanel = new DatabasePanel();
    private SequencePanel sequencePanel = new SequencePanel();
    private TreeElementsPanel treePanel = new TreeElementsPanel();
    private JSplitPane dataComponent = new JSplitPane( JSplitPane.VERTICAL_SPLIT );

    private TreeListener listener = null;

    /** Creates a new instance of PrincipalFrameComponent */
    public PrincipalFrameComponent(PrincipalFrame _frame)
    {
        frame = _frame;
        setPreferredSize(new Dimension(600, 400));
        setDividerLocation(200);
        setOneTouchExpandable(true);

        listener = new TreeListener(this);

        tree_control = new TreeControl(frame);
        tree_toolbar = new TreeToolbar(this);

        JPanel temp = new JPanel(new BorderLayout());
        temp.add(tree_toolbar, BorderLayout.NORTH);
        temp.add(new JScrollPane(tree_control), BorderLayout.CENTER);

        setLeftComponent(temp);

        dataComponent.setDividerLocation(Integer.parseInt(frame.getSystemProperties().getProperty("LOG_DIVIDER_LOCATION", "400")));
        dataComponent.setOneTouchExpandable(true);
        dataComponent.setRightComponent( new LoggingPanel() );

        setRightComponent( dataComponent );

        refreshTree();
    }

    public void updateSelectedObject(TreeInfo _obj)
    {
        int location = dataComponent.getDividerLocation();
        int lastLocation = dataComponent.getLastDividerLocation();
        if(_obj == null)
        {
            last_selected = null;
            dataComponent.setLeftComponent( default_panel );
        } else if ((last_selected == null) || (last_selected != _obj))
        {
            last_selected = _obj;
            if (_obj.getClass() == RootElement.class)
            {
                dbRootPanel.setDatabase(((RootElement) _obj).getDatabase());
                dataComponent.setLeftComponent(dbRootPanel);
            } else if (_obj.getClass() == Element.class)
            {
                DBObject tmp_element = ((Element) _obj).getSource();
                if(tmp_element.getClass() == Table.class)
                {
                    tablePanel.setTable((Table) tmp_element);
                    dataComponent.setLeftComponent(tablePanel);
                } else if(tmp_element.getClass() == View.class)
                {
                    viewPanel.setView((View) tmp_element);
                    dataComponent.setLeftComponent(viewPanel);
                } else if(tmp_element.getClass() == Database.class)
                {
                    databasePanel.setDatabase((Database) tmp_element);
                    dataComponent.setLeftComponent(databasePanel);
                } else if(tmp_element.getClass() == User.class)
                {
                    userPanel.setUser((User) tmp_element);
                    dataComponent.setLeftComponent(userPanel);
                } else if(tmp_element.getClass() == Group.class)
                {
                    groupPanel.setGroup((Group) tmp_element);
                    dataComponent.setLeftComponent(groupPanel);
                } else if(tmp_element.getClass() == Sequence.class)
                {
                    sequencePanel.setSequence((Sequence) tmp_element);
                    dataComponent.setLeftComponent(sequencePanel);
                }
            } else if (TreeInfo.class.isInstance(_obj)) {
                treePanel.setTreeElement(_obj);
                dataComponent.setLeftComponent(treePanel);
            } else {
                last_selected = null;
                dataComponent.setLeftComponent(default_panel);
            }
        }
        
        dataComponent.setDividerLocation(location);
        dataComponent.setLastDividerLocation(lastLocation);
        tree_toolbar.refreshValidation();
    }
    public TreeInfo getLastSelected(){
        return last_selected;
    }

    public void newObject(){
    }
    public void deleteObject(){
        if ((getLastSelected() != null) && (getLastSelected().getClass() == Element.class)) {
            DBObject tmp_element = ((Element) getLastSelected()).getSource();
            if(JOptionPane.showConfirmDialog(frame, "Do you want to delete the object " + tmp_element.getName()) == JOptionPane.OK_OPTION) {
                if(tmp_element.Drop()){
                    refreshTree();
                }
            }
        }
    }
    public void editObject(){
    }

    public void refreshValidation(){
        if(frame != null){
            boolean valid = frame.getDatabase().validate();
            if(!valid){
                dataComponent.setLeftComponent(default_panel);
            }
        }
    }

    public void refreshTree(){
        frame.setDatabase(Database.getMainConnection());
        tree_control.refreshTree();
        tree_toolbar.refreshValidation();
    }

    public void setDataComponent(Component _component){
        dataComponent.setLeftComponent(_component);
    }

    public TreeListener getListener(){
        return listener;
    }
    
    public JSplitPane getDataComponent(){
        return dataComponent;
    }
    
}
