/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.objects;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import javax.swing.JOptionPane;
import pgclibrary.objects.DBObject;
import pgclibrary.utilities.Utilities;

public class User
extends DBObject {
    private String password = new String();
    private boolean user_createDB = false;
    private boolean user_trace = false;
    private boolean user_super = false;
    private boolean user_captupd = false;
    private Date user_valuntil = null;
    private long sysID = -1L;

    public User(DBObject dBObject, String string) {
        super(dBObject);
        this.search(string);
    }

    public User(DBObject dBObject, long l) {
        super(dBObject);
        this.search(l);
    }

    public User(DBObject dBObject) {
        super(dBObject);
    }

    public boolean Drop() {
        boolean bl = false;
        try {
            bl = this.getConnection().executeUpdate("DROP USER " + this.getName()) > 0;
        }
        catch (SQLException sQLException) {
            JOptionPane.showMessageDialog(null, sQLException.getMessage(), "Can't drop object", 0);
        }
        return bl;
    }

    public String getDeleteSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DROP USER ");
        stringBuffer.append(this.getName());
        stringBuffer.append(";\n ");
        return stringBuffer.toString();
    }

    public String getInsertSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE USER ");
        stringBuffer.append(this.getName()).append(" ");
        if (this.getPassword().length() > 0 || this.isDBCreateor() || this.isSuperUser() || this.getValidLimit() != null) {
            stringBuffer.append("WITH ");
            if (this.getPassword().length() > 0) {
                stringBuffer.append("PASSWORD '").append(this.getPassword()).append("' \n");
            }
            if (this.isDBCreateor()) {
                stringBuffer.append("CREATEDB ");
            }
            if (this.isSuperUser()) {
                stringBuffer.append("CREATEUSER ");
            }
            if (this.getValidLimit() != null) {
                stringBuffer.append("VALID UNTIL '").append(Utilities.formatDate(this.getValidLimit(), "MMM d yyyy")).append("' ");
            }
        }
        stringBuffer.append(";\n");
        return stringBuffer.toString();
    }

    public boolean search(String string) {
        boolean bl = false;
        try {
            this.initialize();
            ResultSet resultSet = this.getConnection().getQueryGenerator().getUser(string);
            this.storeData(resultSet);
            bl = true;
            resultSet.close();
            resultSet.getStatement().close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return bl;
    }

    public boolean search(long l) {
        boolean bl = false;
        try {
            this.initialize();
            ResultSet resultSet = this.getConnection().getQueryGenerator().getUser(l);
            this.storeData(resultSet);
            bl = true;
            resultSet.close();
            resultSet.getStatement().close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return bl;
    }

    private void storeData(ResultSet resultSet) throws SQLException {
        if (resultSet != null && resultSet.next()) {
            this.setName(resultSet.getString("user_name"));
            this.sysID = resultSet.getLong("user_sysid");
            this.setDBCreator(resultSet.getBoolean("user_dbcreator"));
            this.setTraceUser(resultSet.getBoolean("user_dbcreator"));
            this.setSuperUser(resultSet.getBoolean("user_dbcreator"));
            this.setCanUpdateSystemCatalog(resultSet.getBoolean("user_dbcreator"));
            this.setValidLimit(resultSet.getTimestamp("user_limitdate"));
        }
    }

    public void initialize() {
        super.initialize();
        this.password = new String();
        this.user_createDB = false;
        this.user_trace = false;
        this.user_super = false;
        this.user_captupd = false;
        this.user_valuntil = null;
    }

    public boolean isDBCreateor() {
        return this.user_createDB;
    }

    public boolean isTraceUser() {
        return this.user_trace;
    }

    public boolean isSuperUser() {
        return this.user_super;
    }

    public boolean canUpdateSystemCatalog() {
        return this.user_captupd;
    }

    public Date getValidLimit() {
        return this.user_valuntil;
    }

    public void setValidLimit(Timestamp timestamp) {
        this.user_valuntil = timestamp != null ? new java.sql.Date(((Date)timestamp).getTime()) : null;
    }

    public void refresh() {
        this.search(this.getName());
    }

    private void setPassword(String string) {
        this.password = string != null ? string : new String();
    }

    private String getPassword() {
        return this.password;
    }

    private void setDBCreator(boolean bl) {
        this.user_createDB = bl;
    }

    private void setTraceUser(boolean bl) {
        this.user_trace = bl;
    }

    private void setSuperUser(boolean bl) {
        this.user_super = bl;
    }

    private void setCanUpdateSystemCatalog(boolean bl) {
        this.user_captupd = bl;
    }

    private void setValidLimit(Date date) {
        this.user_valuntil = date != null ? date : null;
    }
}

