/*
 * Decompiled with CFR 0.152.
 */
package components;

import javax.swing.JTextArea;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.spi.LoggingEvent;

public class TextAreaAppender
extends AppenderSkeleton {
    private JTextArea textArea;
    private Layout layout;
    private static TextAreaAppender instance = null;

    public TextAreaAppender() {
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setAutoscrolls(true);
        this.layout = new SimpleLayout();
        instance = this;
    }

    public TextAreaAppender(Layout layout, String string) {
        this.layout = layout;
        this.name = string;
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setAutoscrolls(true);
        instance = this;
    }

    public void enable() {
        this.textArea.enable();
    }

    public static synchronized TextAreaAppender getInstance() {
        if (instance == null) {
            instance = new TextAreaAppender();
        }
        return instance;
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public void setTextArea(JTextArea jTextArea) {
        this.textArea = jTextArea;
    }

    public boolean requiresLayout() {
        return true;
    }

    protected void append(LoggingEvent loggingEvent) {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer(this.layout.format(loggingEvent));
        if (this.layout.ignoresThrowable() && (stringArray = loggingEvent.getThrowableStrRep()) != null) {
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(stringArray[n2]);
                stringBuffer.append(Layout.LINE_SEP);
                ++n2;
            }
        }
        this.textArea.append(stringBuffer.toString());
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }

    public void close() {
    }
}

