/*
 * IndexPanelToolbar.java
 *
 * Created on 1 de agosto de 2002, 16:35
 */

package components.table;
import components.*;
import javax.swing.*;
import java.awt.event.*;

/**
 *
 * @author  nestor
 */
public class IndexPanelToolbar extends JToolBar {
    IndexPanel panel = null;
    JButton sort = null;
    JButton newRecord = null;
    JButton editRecord = null;
    JButton deleteRecord = null;
    
    /** Creates a new instance of IndexPanelToolbar */
    public IndexPanelToolbar(IndexPanel _panel) {
        panel = _panel;
        
        newRecord = new JButton(new ImageIcon(getClass().getResource("/images/new.png")));
        newRecord.setActionCommand(IndexPanelListener.AC_NEW);
        newRecord.setToolTipText("New Index");
        newRecord.addActionListener(panel.getListener());
        this.add(newRecord);
        editRecord = new JButton(new ImageIcon(getClass().getResource("/images/edit.png")));
        editRecord.setActionCommand(IndexPanelListener.AC_EDIT);
        editRecord.setToolTipText("Edit Index");
        editRecord.addActionListener(panel.getListener());
        this.add(editRecord);
        deleteRecord = new JButton(new ImageIcon(getClass().getResource("/images/delete.png")));
        deleteRecord.setActionCommand(IndexPanelListener.AC_DELETE);
        deleteRecord.setToolTipText("Delete Index");
        deleteRecord.addActionListener(panel.getListener());
        this.add(deleteRecord);
        
        this.add(Box.createHorizontalGlue());
    }
    
    public void refreshValidation(){
        if(panel.getTable() != null){
            boolean valid = panel.getTable() != null;
            sort.setEnabled(valid);
            newRecord.setEnabled(valid);
            editRecord.setEnabled(valid);
            deleteRecord.setEnabled(valid);
        }
    }
}
