/*
 * Decompiled with CFR 0.152.
 */
package components.table;

import components.table.TableEditRecordDialogListener;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import pgclibrary.objects.Table;
import pgclibrary.objects.TableColumn;
import pgclibrary.objects.TableIndex;
import pgclibrary.utilities.SUtilities;

public class TableEditRecordDialog
extends JDialog {
    Table table = null;
    Vector columns = new Vector();
    Vector index_data = new Vector();

    public TableEditRecordDialog(Table _table, Vector iniValues) {
        this.setTitle("Edit record");
        this.table = _table;
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TableEditRecordDialog.this.close();
            }
        });
        this.getContentPane().add(this.getContents(iniValues), "Center");
        this.getContentPane().add(this.getButtons(), "South");
        this.setModal(true);
        this.pack();
    }

    private Component getContents(Vector iniValues) {
        TableIndex idx = (TableIndex)this.table.getPrimaryKeys().get(0);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        int i = 0;
        while (i < this.table.getColumns().size()) {
            TableColumn tc = (TableColumn)this.table.getColumns().get(i);
            JTextComponent tf = null;
            if (tc.getSize() < 40) {
                tf = new JTextField(20);
                panel.add(SUtilities.getHorPanel(tc.getName().toUpperCase() + " :", tf));
            } else {
                tf = new JTextArea(3, 20);
                JScrollPane jsp = new JScrollPane(tf);
                jsp.setPreferredSize(tf.getPreferredSize());
                jsp.setAutoscrolls(false);
                panel.add(SUtilities.getHorPanel(tc.getName().toUpperCase() + " :", jsp));
            }
            tf.setText((String)iniValues.get(i));
            if (idx.getColumnIndex(tc.getName()) >= 0) {
                this.index_data.add((String)iniValues.get(i));
            }
            this.columns.add(tf);
            ++i;
        }
        return panel;
    }

    private Component getButtons() {
        TableEditRecordDialogListener listener = new TableEditRecordDialogListener(this);
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createHorizontalGlue());
        JButton okey = new JButton("Update");
        okey.setActionCommand("update");
        okey.addActionListener(listener);
        panel.add(okey);
        panel.add(Box.createHorizontalStrut(5));
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("cancel");
        cancel.addActionListener(listener);
        panel.add(cancel);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    protected void update() {
        Vector<String> data = new Vector<String>();
        int i = 0;
        while (i < this.columns.size()) {
            data.add(((JTextComponent)this.columns.get(i)).getText());
            ++i;
        }
        data.addAll(this.index_data);
        try {
            this.table.updateRecord(data);
            this.dispose();
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Message", 1);
        }
    }

    protected void close() {
        this.dispose();
    }
}

