/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.objects;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import pgclibrary.objects.DBObject;
import pgclibrary.objects.User;

public class Sequence
extends DBObject {
    private long last_value = 0L;
    private long increment_by = 0L;
    private long max_value = 0L;
    private long min_value = 0L;
    private long cache_value = 0L;
    private boolean cycled = false;
    private boolean called = false;
    private long start = 0L;

    public Sequence(DBObject owner, long oid) {
        super(owner);
        this.search(oid);
    }

    public Sequence(DBObject owner) {
        super(owner);
    }

    public String getDeleteSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("DROP SEQUENCE ");
        retorno.append(this.getName()).append(";\n");
        return retorno.toString();
    }

    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("CREATE SEQUENCE ");
        retorno.append(this.getName()).append(" ");
        if (this.getIncrementBy() > 1L) {
            retorno.append("\n\tINCREMENT ").append(this.getIncrementBy()).append(" ");
        }
        if (this.getMinValue() > 0L) {
            retorno.append("\n\tMINVALUE ").append(this.getMinValue()).append(" ");
        }
        if (this.getMaxValue() > 0L) {
            retorno.append("\n\tMAXVALUE ").append(this.getMaxValue()).append(" ");
        }
        if (this.getStart() > 0L) {
            retorno.append("\n\tSTART ").append(this.getStart()).append(" ");
        }
        if (this.getCacheValue() > 0L) {
            retorno.append("\n\tCACHE ").append(this.getCacheValue()).append(" ");
        }
        if (this.isCycled()) {
            retorno.append("\n\tCYCLE ");
        }
        retorno.append(";\n");
        return retorno.toString();
    }

    public String getUpdateSQL() {
        return new String();
    }

    public boolean search(long _oid) {
        boolean retorno = false;
        try {
            this.initialize();
            PreparedStatement prep = this.getConnection().prepareStatement("SELECT OID, * FROM PG_CLASS WHERE OID=?");
            prep.setLong(1, _oid);
            ResultSet rs = prep.executeQuery();
            if (rs.next()) {
                this.setName(rs.getString("RELNAME"));
                this.setOID(rs.getLong("OID"));
                this.setCreator(new User(this, rs.getLong("RELOWNER")));
                PreparedStatement prep1 = this.getConnection().prepareStatement("SELECT * FROM " + this.getName());
                ResultSet rs1 = prep1.executeQuery();
                if (rs1.next()) {
                    this.setLastValue(rs1.getLong("LAST_VALUE"));
                    this.setIncrementBy(rs1.getLong("INCREMENT_BY"));
                    this.setMaxValue(rs1.getLong("MAX_VALUE"));
                    this.setMinValue(rs1.getLong("MIN_VALUE"));
                    this.setCacheValue(rs1.getLong("CACHE_VALUE"));
                    this.setCycled(rs1.getBoolean("IS_CYCLED"));
                    this.setCalled(rs1.getBoolean("IS_CALLED"));
                    retorno = true;
                }
                rs1.close();
                prep1.close();
            }
            rs.close();
            prep.close();
        }
        catch (SQLException e) {
            this.initialize();
        }
        return retorno;
    }

    public void initialize() {
        super.initialize();
        this.start = 0L;
        this.last_value = 0L;
        this.increment_by = 0L;
        this.max_value = 0L;
        this.min_value = 0L;
        this.cache_value = 0L;
        this.cycled = false;
        this.called = false;
    }

    public long getLastValue() {
        return this.last_value;
    }

    private void setLastValue(long _last_value) {
        this.last_value = _last_value;
    }

    public long getIncrementBy() {
        return this.increment_by;
    }

    public void setIncrementBy(long _increment_by) {
        this.increment_by = _increment_by;
    }

    public long getMaxValue() {
        return this.max_value;
    }

    public void setMaxValue(long _max_value) {
        this.max_value = _max_value;
    }

    public long getMinValue() {
        return this.min_value;
    }

    public void setMinValue(long _min_value) {
        this.min_value = _min_value;
    }

    public long getCacheValue() {
        return this.cache_value;
    }

    public void setCacheValue(long _cache_value) {
        this.cache_value = _cache_value;
    }

    public boolean isCycled() {
        return this.cycled;
    }

    public void setCycled(boolean _cycled) {
        this.cycled = _cycled;
    }

    public boolean isCalled() {
        return this.called;
    }

    private void setCalled(boolean _called) {
        this.called = _called;
    }

    private long getStart() {
        return this.start;
    }

    public void setStart(long _start) {
        this.start = _start;
    }
}

