################################################################################
##$Namespace: base64
##$Summary: Provides components for encoding and decoding base64 data
##$Version: 1.0.0
##$Author: Michael E Allen
##$Copyright: Copyright(C)2001 Michael E Allen
##$License: GNU General Public License
##$Create Date: April 23, 2001
##$Description: 
##+	The base64 library contains procedures for encoding and decoding
##+ text strings using the base64 encoding method.
##$Bugs: 
##+	None
##$To Do: 
##+	Nothing
##$Changes:
##+	None
##$Disclaimer:
##+	This program is free software; you can redistribute it and/or modify
##+	it under the terms of the GNU General Public License as published by
##+	the Free Software Foundation; either version 2 of the License, or
##+	(at your option) any later version.
##+	This program is distributed in the hope that it will be useful,
##+	but WITHOUT ANY WARRANTY; without even the implied warranty of
##+	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##+	GNU General Public License for more details.
##+	
##+	You should have received a copy of the GNU General Public License
##+	along with this program; if not, write to the Free Software
##+	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
################################################################################
namespace eval url::base64 {
    variable lIndex 0
    variable lCharacter
    variable mDecoder
    variable mEncoder

    foreach lCharacter {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z \
	a b c d e f g h i j k l m n o p q r s t u v w x y z \
	0 1 2 3 4 5 6 7 8 9 + /} {
		set mDecoder($lCharacter) $lIndex
		set mEncoder($lIndex) $lCharacter
		incr lIndex
    }

	################################################################################
	##$Procedure: Encode
	##$Summary: Encode a string into base 64
	##$Version: 1.0.0
	##$Author: Michael E Allen
	##$Create Date: April 23, 2001
	##$Description:
	##+	Takes the given string and encodes it using the base64 encoding method
	##$Bugs: 
	##+	None
	##$To Do: 
	##+	Nothing
	##$Changes:
	##+	None
	##$Synopsis:
	##+	::url::base64::Encode string ?maxlen? ?delimter?
	##$Parameters:
	##+	maxlen
	##+		Indicates the maximum number of characters to ouput before inserting
	##+		a newline.  If maxlen is 0, indicates that no wrapping will be
	##+		performed.  The default maximum line length is set to match the 
	##+		output of GNU uuencode 4.2, 60 characters.  Various RFC's allow 
	##+		for different wrap lengths.
	##+	delimter
	##+		Indicates the character to use for wrapping the lines.  the
	##+		default is to match the output of GNU uuencode 4.2, which is 
	##+		newline.  Various RFC's allow for different wrapping characters.
	##$Result:
	##+	Returns a text string that is base64 encoded
	################################################################################
	proc Encode {pString {pLength 60} {pDelimiter "\n"}} {
	    variable mEncoder
    
	    set lResult ""
    	set lState 0
    	set lLength 0

	    foreach lCharacter [split $pString ""] {
			if {($pLength && $lLength >= $pLength)} {
				append lResult $pDelimiter
				set lLength 0
			}
			scan $lCharacter "%c" lCharacterValue
			switch [incr lState] {
				1 {	
					append lResult $mEncoder([expr {($lCharacterValue >>2) & 0x3F}]) 
				}
				2 { 
					append lResult $mEncoder([expr {(($lOldCharacterValue << 4) & 0x30) | (($lCharacterValue >> 4) & 0xF)}]) 
				}
				3 { 
					append lResult $mEncoder([expr {(($lOldCharacterValue << 2) & 0x3C) | (($lCharacterValue >> 6) & 0x3)}])
					append lResult $mEncoder([expr {($lCharacterValue & 0x3F)}])
					incr lLength
					set lState 0
				}
			}
			set lOldCharacterValue $lCharacterValue
			incr lLength
	    }

	    set x 0
	    switch $lState {
			0 { 
			}
			1 { 
				append lResult $mEncoder([expr {(($lOldCharacterValue << 4) & 0x30)}])== 
			}
			2 { append lResult $mEncoder([expr {(($lOldCharacterValue << 2) & 0x3C)}])=  
			}
    	}
    	return $lResult
	}

	################################################################################
	##$Procedure: Decode
	##$Summary: Decode a base64 encoded string
	##$Version: 1.0.0
	##$Author: Michael E Allen
	##$Create Date: April 23, 2001
	##$Description:
	##+	Takes the given string and decodes it using the base64 decoding method
	##$Bugs: 
	##+	None
	##$To Do: 
	##+	Nothing
	##$Changes:
	##+	None
	##$Synopsis:
	##+	::url::base64::Decode string
	##$Parameters:
	##+	string
	##+		A string that has been previously encoded using the base64 encoding
	##+		method.  Characters not in the base64 alphabet are 
	##+		ignored (e.g., newlines).
	##$Result:
	##+	Returns a text string containing the decoded text
	################################################################################
	proc Decode {pString} {
		variable mDecoder

		set lResult ""
		set lGroup 0
		set lBitCount 18
		foreach lCharacter [split $pString ""] {
			if {[string compare $lResult "="]} {
				if {(![info exists mDecoder($lCharacter)])} {
					continue
				}
				set lBits $mDecoder($lCharacter)
				set lGroup [expr {$lGroup | ($lBits << $lBitCount)}]
				if {[incr lBitCount -6] < 0} {
					scan [format %06x $lGroup] "%2x%2x%2x" lCharacter1 lCharacter2 lCharacter3
					append lResult [format "%c%c%c" $lCharacter1 $lCharacter2 $lCharacter3]
					set lGroup 0
					set lBitCount 18
				}
			} else {

				scan [format %06x $group] "%2x%2x%2x" lCharacter1 lCharacter2 lCharacter3
				if {$lBitCount == 6} {
					append lResult [format "%c" $lCharacter1]
				} elseif {$lBitCount == 0} {
					append lResult [format "%c%c" $lCharacter1 $lCharacter2]
				}
				break
			}
		}
		return $lResult
	}
}
