/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.clearcase;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.clearcase.ClearCase;
import org.apache.tools.ant.types.Commandline;

public class CCUpdate
extends ClearCase {
    public static final String FLAG_GRAPHICAL = "-graphical";
    public static final String FLAG_LOG = "-log";
    public static final String FLAG_OVERWRITE = "-overwrite";
    public static final String FLAG_NOVERWRITE = "-noverwrite";
    public static final String FLAG_RENAME = "-rename";
    public static final String FLAG_CURRENTTIME = "-ctime";
    public static final String FLAG_PRESERVETIME = "-ptime";
    private boolean m_Graphical = false;
    private boolean m_Overwrite = false;
    private boolean m_Rename = false;
    private boolean m_Ctime = false;
    private boolean m_Ptime = false;
    private String m_Log = null;

    public void execute() throws BuildException {
        Commandline commandLine = new Commandline();
        Project aProj = this.getProject();
        int result = 0;
        if (this.getViewPath() == null) {
            this.setViewPath(aProj.getBaseDir().getPath());
        }
        commandLine.setExecutable(this.getClearToolCommand());
        commandLine.createArgument().setValue("update");
        this.checkOptions(commandLine);
        System.out.println(commandLine.toString());
        result = this.run(commandLine);
        if (result != 0) {
            String msg = "Failed executing: " + commandLine.toString();
            throw new BuildException(msg, this.location);
        }
    }

    private void checkOptions(Commandline cmd) {
        if (this.getGraphical()) {
            cmd.createArgument().setValue(FLAG_GRAPHICAL);
        } else {
            if (this.getOverwrite()) {
                cmd.createArgument().setValue(FLAG_OVERWRITE);
            } else if (this.getRename()) {
                cmd.createArgument().setValue(FLAG_RENAME);
            } else {
                cmd.createArgument().setValue(FLAG_NOVERWRITE);
            }
            if (this.getCurrentTime()) {
                cmd.createArgument().setValue(FLAG_CURRENTTIME);
            } else if (this.getPreserveTime()) {
                cmd.createArgument().setValue(FLAG_PRESERVETIME);
            }
            this.getLogCommand(cmd);
        }
        cmd.createArgument().setValue(this.getViewPath());
    }

    public void setGraphical(boolean graphical) {
        this.m_Graphical = graphical;
    }

    public boolean getGraphical() {
        return this.m_Graphical;
    }

    public void setOverwrite(boolean ow) {
        this.m_Overwrite = ow;
    }

    public boolean getOverwrite() {
        return this.m_Overwrite;
    }

    public void setRename(boolean ren) {
        this.m_Rename = ren;
    }

    public boolean getRename() {
        return this.m_Rename;
    }

    public void setCurrentTime(boolean ct) {
        this.m_Ctime = ct;
    }

    public boolean getCurrentTime() {
        return this.m_Ctime;
    }

    public void setPreserveTime(boolean pt) {
        this.m_Ptime = pt;
    }

    public boolean getPreserveTime() {
        return this.m_Ptime;
    }

    public void setLog(String log) {
        this.m_Log = log;
    }

    public String getLog() {
        return this.m_Log;
    }

    private void getLogCommand(Commandline cmd) {
        if (this.getLog() == null) {
            return;
        }
        cmd.createArgument().setValue(FLAG_LOG);
        cmd.createArgument().setValue(this.getLog());
    }
}

