/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.DOMExceptionImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.LCount;
import org.apache.xerces.dom.NamedNodeMapImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.events.MutationEventImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;

public class AttributeMap
extends NamedNodeMapImpl {
    protected AttributeMap(ElementImpl elementImpl, NamedNodeMapImpl namedNodeMapImpl) {
        super(elementImpl);
        if (namedNodeMapImpl != null) {
            this.cloneContent(namedNodeMapImpl);
            if (this.nodes != null) {
                this.hasDefaults(true);
            }
        }
    }

    public NamedNodeMapImpl cloneMap(NodeImpl nodeImpl) {
        AttributeMap attributeMap = new AttributeMap((ElementImpl)nodeImpl, null);
        attributeMap.hasDefaults(this.hasDefaults());
        attributeMap.cloneContent(this);
        return attributeMap;
    }

    protected final Node internalRemoveNamedItem(String string, boolean bl) {
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7, "DOM001 Modification not allowed");
        }
        int n = this.findNamePoint(string, 0);
        if (n < 0) {
            if (bl) {
                throw new DOMExceptionImpl(8, "DOM008 Not found");
            }
            return null;
        }
        NodeImpl nodeImpl = (NodeImpl)this.nodes.elementAt(n);
        if (this.hasDefaults()) {
            Node node;
            NamedNodeMapImpl namedNodeMapImpl = ((ElementImpl)this.ownerNode).getDefaultAttributes();
            if (namedNodeMapImpl != null && (node = namedNodeMapImpl.getNamedItem(string)) != null && this.findNamePoint(string, n + 1) < 0) {
                NodeImpl nodeImpl2 = (NodeImpl)node.cloneNode(true);
                nodeImpl2.ownerNode = this.ownerNode;
                nodeImpl2.isOwned(true);
                nodeImpl2.isSpecified(false);
                this.nodes.setElementAt(nodeImpl2, n);
            } else {
                this.nodes.removeElementAt(n);
            }
        } else {
            this.nodes.removeElementAt(n);
        }
        nodeImpl.ownerNode = this.ownerNode.ownerDocument();
        nodeImpl.isOwned(false);
        nodeImpl.isSpecified(true);
        return nodeImpl;
    }

    protected final Node internalRemoveNamedItemNS(String string, String string2, boolean bl) {
        Object object;
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7, "DOM001 Modification not allowed");
        }
        int n = this.findNamePoint(string, string2);
        if (n < 0) {
            if (bl) {
                throw new DOMExceptionImpl(8, "DOM008 Not found");
            }
            return null;
        }
        LCount lCount = null;
        String string3 = "";
        AttrImpl attrImpl = null;
        if (this.ownerNode.ownerDocument().mutationEvents) {
            lCount = LCount.lookup("DOMAttrModified");
            if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
                attrImpl = (AttrImpl)this.nodes.elementAt(n);
                string3 = attrImpl.getNodeValue();
            }
        }
        NodeImpl nodeImpl = (NodeImpl)this.nodes.elementAt(n);
        String string4 = nodeImpl.getNodeName();
        if (this.hasDefaults()) {
            Node node;
            object = ((ElementImpl)this.ownerNode).getDefaultAttributes();
            if (object != null && (node = ((NamedNodeMapImpl)object).getNamedItem(string4)) != null) {
                int n2 = this.findNamePoint(string4, 0);
                if (n2 >= 0 && this.findNamePoint(string4, n2 + 1) < 0) {
                    NodeImpl nodeImpl2 = (NodeImpl)node.cloneNode(true);
                    nodeImpl2.ownerNode = this.ownerNode;
                    nodeImpl2.isOwned(true);
                    nodeImpl2.isSpecified(false);
                    this.nodes.setElementAt(nodeImpl2, n);
                } else {
                    this.nodes.removeElementAt(n);
                }
            } else {
                this.nodes.removeElementAt(n);
            }
        } else {
            this.nodes.removeElementAt(n);
        }
        nodeImpl.ownerNode = this.ownerNode.ownerDocument();
        nodeImpl.isOwned(false);
        nodeImpl.isSpecified(true);
        if (this.ownerNode.ownerDocument().mutationEvents) {
            if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
                object = new MutationEventImpl();
                object.initMutationEvent("DOMAttrModified", true, false, null, nodeImpl.getNodeValue(), ((ElementImpl)this.ownerNode).getAttribute(string2), string2);
                this.ownerNode.dispatchEvent((Event)object);
            }
            this.ownerNode.dispatchAggregateEvents(null, null);
        }
        return nodeImpl;
    }

    public Node removeNamedItem(String string) throws DOMException {
        return this.internalRemoveNamedItem(string, true);
    }

    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        return this.internalRemoveNamedItemNS(string, string2, true);
    }

    Node safeRemoveNamedItem(String string) {
        return this.internalRemoveNamedItem(string, false);
    }

    Node safeRemoveNamedItemNS(String string, String string2) {
        return this.internalRemoveNamedItemNS(string, string2, false);
    }

    public Node setNamedItem(Node node) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7, "DOM001 Modification not allowed");
        }
        if (node.getOwnerDocument() != this.ownerNode.ownerDocument()) {
            throw new DOMExceptionImpl(4, "DOM005 Wrong document");
        }
        NodeImpl nodeImpl = (NodeImpl)node;
        if (nodeImpl.isOwned()) {
            throw new DOMExceptionImpl(10, "DOM009 Attribute already in use");
        }
        nodeImpl.ownerNode = this.ownerNode;
        nodeImpl.isOwned(true);
        int n = this.findNamePoint(node.getNodeName(), 0);
        NodeImpl nodeImpl2 = null;
        if (n >= 0) {
            nodeImpl2 = (NodeImpl)this.nodes.elementAt(n);
            this.nodes.setElementAt(node, n);
            nodeImpl2.ownerNode = this.ownerNode.ownerDocument();
            nodeImpl2.isOwned(false);
            nodeImpl2.isSpecified(true);
        } else {
            n = -1 - n;
            if (this.nodes == null) {
                this.nodes = new Vector(5, 10);
            }
            this.nodes.insertElementAt(node, n);
        }
        if (this.ownerNode.ownerDocument().mutationEvents) {
            this.ownerNode.dispatchAggregateEvents((AttrImpl)node, nodeImpl2 == null ? null : nodeImpl2.getNodeValue());
        }
        return nodeImpl2;
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7, "DOM001 Modification not allowed");
        }
        if (node.getOwnerDocument() != this.ownerNode.ownerDocument()) {
            throw new DOMExceptionImpl(4, "DOM005 Wrong document");
        }
        NodeImpl nodeImpl = (NodeImpl)node;
        if (nodeImpl.isOwned()) {
            throw new DOMExceptionImpl(10, "DOM009 Attribute already in use");
        }
        nodeImpl.ownerNode = this.ownerNode;
        nodeImpl.isOwned(true);
        int n = this.findNamePoint(nodeImpl.getNamespaceURI(), nodeImpl.getLocalName());
        NodeImpl nodeImpl2 = null;
        if (n >= 0) {
            nodeImpl2 = (NodeImpl)this.nodes.elementAt(n);
            this.nodes.setElementAt(node, n);
            nodeImpl2.ownerNode = this.ownerNode.ownerDocument();
            nodeImpl2.isOwned(false);
            nodeImpl2.isSpecified(true);
        } else {
            n = this.findNamePoint(node.getNodeName(), 0);
            if (n >= 0) {
                nodeImpl2 = (NodeImpl)this.nodes.elementAt(n);
                this.nodes.insertElementAt(node, n);
            } else {
                n = -1 - n;
                if (this.nodes == null) {
                    this.nodes = new Vector(5, 10);
                }
                this.nodes.insertElementAt(node, n);
            }
        }
        if (this.ownerNode.ownerDocument().mutationEvents) {
            this.ownerNode.dispatchAggregateEvents((AttrImpl)node, nodeImpl2 == null ? null : nodeImpl2.getNodeValue());
        }
        return nodeImpl2;
    }
}

