/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.SAXParser;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.ejb.DescriptorHandler;
import org.apache.tools.ant.taskdefs.optional.ejb.EJBDeploymentTool;
import org.apache.tools.ant.taskdefs.optional.ejb.InnerClassFilenameFilter;
import org.apache.tools.ant.types.Path;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GenericDeploymentTool
implements EJBDeploymentTool {
    protected static final String META_DIR = "META-INF/";
    protected static final String EJB_DD = "ejb-jar.xml";
    private File srcDir;
    private File descriptorDir;
    private File destDir;
    private String baseJarName;
    private Path classpath;
    private boolean flatDestDir = false;
    private String baseNameTerminator = "-";
    private String genericJarSuffix = "-generic.jar";
    private Task task;
    private ClassLoader classpathLoader = null;
    private List addedfiles;

    public void setDestdir(File inDir) {
        this.destDir = inDir;
    }

    protected File getDestDir() {
        return this.destDir;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    protected Task getTask() {
        return this.task;
    }

    protected String getBaseNameTerminator() {
        return this.baseNameTerminator;
    }

    protected String getBaseJarName() {
        return this.baseJarName;
    }

    protected File getSrcDir() {
        return this.srcDir;
    }

    protected File getDescriptorDir() {
        return this.descriptorDir;
    }

    protected boolean usingBaseJarName() {
        return this.baseJarName != null;
    }

    public void setGenericJarSuffix(String inString) {
        this.genericJarSuffix = inString;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.task.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspath(Path classpath) {
        this.classpath = classpath;
    }

    protected Path getClasspath() {
        return this.classpath;
    }

    protected void log(String message, int level) {
        this.getTask().log(message, level);
    }

    public void configure(File srcDir, File descriptorDir, String baseNameTerminator, String baseJarName, boolean flatDestDir, Path classpath) {
        this.srcDir = srcDir;
        this.descriptorDir = descriptorDir;
        this.baseJarName = baseJarName;
        this.baseNameTerminator = baseNameTerminator;
        this.flatDestDir = flatDestDir;
        if (this.classpath != null) {
            this.classpath.append(classpath);
        } else {
            this.classpath = classpath;
        }
        this.classpathLoader = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addFileToJar(JarOutputStream jStream, File inputFile, String logicalFilename) throws BuildException {
        FileInputStream iStream = null;
        try {
            try {
                if (!this.addedfiles.contains(logicalFilename)) {
                    iStream = new FileInputStream(inputFile);
                    ZipEntry zipEntry = new ZipEntry(logicalFilename);
                    jStream.putNextEntry(zipEntry);
                    byte[] byteBuffer = new byte[2048];
                    int count = 0;
                    do {
                        jStream.write(byteBuffer, 0, count);
                    } while ((count = iStream.read(byteBuffer, 0, byteBuffer.length)) != -1);
                    this.addedfiles.add(logicalFilename);
                }
            }
            catch (IOException ioe) {
                String msg = "IOException while adding entry " + logicalFilename + " to jarfile from " + inputFile.getPath() + "." + ioe.getMessage();
                throw new BuildException(msg, (Throwable)ioe);
            }
            Object var6_11 = null;
            if (iStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            if (iStream == null) throw throwable;
            try {
                iStream.close();
                throw throwable;
            }
            catch (IOException closeException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException closeException) {}
        iStream.close();
        return;
    }

    protected DescriptorHandler getDescriptorHandler(File srcDir) {
        return new DescriptorHandler(srcDir);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processDescriptor(String descriptorFileName, SAXParser saxParser) {
        FileInputStream descriptorStream = null;
        try {
            try {
                DescriptorHandler handler = this.getDescriptorHandler(this.srcDir);
                descriptorStream = new FileInputStream(new File(this.getDescriptorDir(), descriptorFileName));
                saxParser.parse(new InputSource(descriptorStream), (HandlerBase)handler);
                Hashtable ejbFiles = handler.getFiles();
                String baseName = "";
                if (this.baseJarName != null) {
                    baseName = this.baseJarName;
                } else {
                    int lastSeparatorIndex = descriptorFileName.lastIndexOf(File.separator);
                    int endBaseName = -1;
                    endBaseName = lastSeparatorIndex != -1 ? descriptorFileName.indexOf(this.baseNameTerminator, lastSeparatorIndex) : descriptorFileName.indexOf(this.baseNameTerminator);
                    if (endBaseName != -1) {
                        baseName = descriptorFileName.substring(0, endBaseName);
                    }
                    baseName = descriptorFileName.substring(0, endBaseName);
                }
                ejbFiles.put("META-INF/ejb-jar.xml", new File(this.getDescriptorDir(), descriptorFileName));
                this.addVendorFiles(ejbFiles, baseName);
                this.checkAndAddInherited(ejbFiles);
                if (this.flatDestDir && baseName.length() != 0) {
                    int startName = baseName.lastIndexOf(File.separator);
                    if (startName == -1) {
                        startName = 0;
                    }
                    int endName = baseName.length();
                    baseName = baseName.substring(startName, endName);
                }
                File jarFile = this.getVendorOutputJarFile(baseName);
                boolean needBuild = true;
                if (jarFile.exists()) {
                    long lastBuild = jarFile.lastModified();
                    Iterator fileIter = ejbFiles.values().iterator();
                    needBuild = false;
                    while (!needBuild && fileIter.hasNext()) {
                        File currentFile = (File)fileIter.next();
                        needBuild = lastBuild < currentFile.lastModified();
                        if (!needBuild) continue;
                        this.log("Build needed because " + currentFile.getPath() + " is out of date", 3);
                    }
                }
                if (needBuild) {
                    this.log("building " + jarFile.getName() + " with " + String.valueOf(ejbFiles.size()) + " files", 2);
                    this.writeJar(baseName, jarFile, ejbFiles);
                } else {
                    this.log(jarFile.toString() + " is up to date.", 2);
                }
            }
            catch (SAXException se) {
                String msg = "SAXException while parsing '" + descriptorFileName.toString() + "'. This probably indicates badly-formed XML." + "  Details: " + se.getMessage();
                throw new BuildException(msg, (Throwable)se);
            }
            catch (IOException ioe) {
                String msg = "IOException while parsing'" + descriptorFileName.toString() + "'.  This probably indicates that the descriptor" + " doesn't exist. Details: " + ioe.getMessage();
                throw new BuildException(msg, (Throwable)ioe);
            }
            Object var5_18 = null;
            if (descriptorStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_19 = null;
            if (descriptorStream == null) throw throwable;
            try {
                descriptorStream.close();
                throw throwable;
            }
            catch (IOException closeException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException closeException) {}
        descriptorStream.close();
        return;
    }

    protected void addVendorFiles(Hashtable ejbFiles, String baseName) {
    }

    File getVendorOutputJarFile(String baseName) {
        return new File(this.destDir, baseName + this.genericJarSuffix);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeJar(String baseName, File jarfile, Hashtable files) throws BuildException {
        ZipOutputStream jarStream = null;
        try {
            try {
                this.addedfiles = new ArrayList();
                if (jarfile.exists()) {
                    jarfile.delete();
                }
                jarfile.getParentFile().mkdirs();
                jarfile.createNewFile();
                jarStream = new JarOutputStream(new FileOutputStream(jarfile));
                jarStream.setMethod(8);
                Iterator entryIterator = files.keySet().iterator();
                while (entryIterator.hasNext()) {
                    String entryName = (String)entryIterator.next();
                    File entryFile = (File)files.get(entryName);
                    this.log("adding file '" + entryName + "'", 3);
                    this.addFileToJar((JarOutputStream)jarStream, entryFile, entryName);
                    InnerClassFilenameFilter flt = new InnerClassFilenameFilter(entryFile.getName());
                    File entryDir = entryFile.getParentFile();
                    String[] innerfiles = entryDir.list(flt);
                    int i = 0;
                    int n = innerfiles.length;
                    while (i < n) {
                        entryName = entryName.substring(0, entryName.lastIndexOf(entryFile.getName()) - 1) + File.separatorChar + innerfiles[i];
                        entryFile = new File(this.srcDir, entryName);
                        this.log("adding innerclass file '" + entryName + "'", 3);
                        this.addFileToJar((JarOutputStream)jarStream, entryFile, entryName);
                        ++i;
                    }
                }
            }
            catch (IOException ioe) {
                String msg = "IOException while processing ejb-jar file '" + jarfile.toString() + "'. Details: " + ioe.getMessage();
                throw new BuildException(msg, (Throwable)ioe);
            }
            Object var6_16 = null;
            if (jarStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_17 = null;
            if (jarStream == null) throw throwable;
            try {
                jarStream.close();
                throw throwable;
            }
            catch (IOException closeException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException closeException) {}
        jarStream.close();
        return;
    }

    protected void checkAndAddInherited(Hashtable checkEntries) throws BuildException {
        Hashtable copiedHash = (Hashtable)checkEntries.clone();
        Iterator entryIterator = copiedHash.keySet().iterator();
        while (entryIterator.hasNext()) {
            String entryName = (String)entryIterator.next();
            File entryFile = (File)copiedHash.get(entryName);
            if (!entryName.endsWith(".class")) continue;
            String classname = entryName.substring(0, entryName.lastIndexOf(".class")).replace(File.separatorChar, '.');
            ClassLoader loader = this.getClassLoaderForBuild();
            try {
                File superClassFile;
                Class<?> c = loader.loadClass(classname);
                if (c.isPrimitive()) continue;
                if (c.isInterface()) {
                    this.log("looking at interface " + c.getName(), 3);
                    Class<?>[] interfaces = c.getInterfaces();
                    int i = 0;
                    while (i < interfaces.length) {
                        File superClassFile2;
                        this.log("     implements " + interfaces[i].getName(), 3);
                        if (!interfaces[i].getName().equals("javax.ejb.EJBObject") && (superClassFile2 = new File(this.srcDir.getAbsolutePath() + File.separatorChar + interfaces[i].getName().replace('.', File.separatorChar) + ".class")).exists() && superClassFile2.isFile() && this.checkInterfaceClasses(interfaces[i].getName().replace('.', File.separatorChar) + ".class", superClassFile2, checkEntries)) {
                            checkEntries.put(interfaces[i].getName().replace('.', File.separatorChar) + ".class", superClassFile2);
                        }
                        ++i;
                    }
                    continue;
                }
                this.log("looking at class " + c.getName(), 3);
                Class<?> s = c.getSuperclass();
                if (s.getName().equals("java.lang.Object") || !(superClassFile = new File(this.srcDir.getAbsolutePath() + File.separatorChar + s.getName().replace('.', File.separatorChar) + ".class")).exists() || !superClassFile.isFile()) continue;
                this.checkSuperClasses(s.getName().replace('.', File.separatorChar) + ".class", superClassFile, checkEntries);
                checkEntries.put(s.getName().replace('.', File.separatorChar) + ".class", superClassFile);
            }
            catch (ClassNotFoundException cnfe) {
                this.log("Could not load class " + classname + " for super class check", 1);
            }
        }
    }

    protected ClassLoader getClassLoaderForBuild() {
        if (this.classpathLoader != null) {
            return this.classpathLoader;
        }
        this.classpathLoader = this.classpath == null ? this.getClass().getClassLoader() : new AntClassLoader(this.getTask().getProject(), this.classpath);
        return this.classpathLoader;
    }

    protected void checkSuperClasses(String entryName, File entryFile, Hashtable checkEntries) {
        try {
            File superClassFile;
            String classname;
            ClassLoader loader;
            Class<?> c;
            Class<?> s;
            if (entryName.endsWith(".class") && !(s = (c = (loader = this.getClassLoaderForBuild()).loadClass(classname = entryName.substring(0, entryName.lastIndexOf(".class")).replace(File.separatorChar, '.'))).getSuperclass()).getName().equals("java.lang.Object") && (superClassFile = new File(this.srcDir.getAbsolutePath() + File.separatorChar + s.getName().replace('.', File.separatorChar) + ".class")).exists() && superClassFile.isFile()) {
                this.checkSuperClasses(s.getName().replace('.', File.separatorChar) + ".class", superClassFile, checkEntries);
                checkEntries.put(s.getName().replace('.', File.separatorChar) + ".class", superClassFile);
            }
        }
        catch (ClassNotFoundException cnfe) {
            String cnfmsg = "ClassNotFoundException while processing ejb-jar file. Details: " + cnfe.getMessage();
            throw new BuildException(cnfmsg, (Throwable)cnfe);
        }
    }

    protected boolean checkInterfaceClasses(String entryName, File entryFile, Hashtable checkEntries) {
        boolean addit = false;
        try {
            if (entryName.endsWith(".class")) {
                ClassLoader loader = this.getClassLoaderForBuild();
                String classname = entryName.substring(0, entryName.lastIndexOf(".class")).replace(File.separatorChar, '.');
                Class<?> c = loader.loadClass(classname);
                Class<?>[] interfaces = c.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    if (!interfaces[i].getName().equals("javax.ejb.EJBObject")) {
                        File superClassFile = new File(this.srcDir.getAbsolutePath() + File.separatorChar + interfaces[i].getName().replace('.', File.separatorChar) + ".class");
                        if (superClassFile.exists() && superClassFile.isFile()) {
                            this.log("looking at interface " + interfaces[i].getName(), 3);
                            addit = this.checkInterfaceClasses(interfaces[i].getName().replace('.', File.separatorChar) + ".class", superClassFile, checkEntries);
                            if (addit) {
                                this.log("adding at interface " + interfaces[i].getName(), 3);
                                checkEntries.put(interfaces[i].getName().replace('.', File.separatorChar) + ".class", superClassFile);
                            }
                        }
                    } else {
                        addit = true;
                    }
                    ++i;
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            String cnfmsg = "ClassNotFoundException while processing ejb-jar file. Details: " + cnfe.getMessage();
            throw new BuildException(cnfmsg, (Throwable)cnfe);
        }
        return addit;
    }

    public void validateConfigured() throws BuildException {
        if (this.destDir == null) {
            throw new BuildException("The destdir attribute must be specified");
        }
    }
}

