/*
 * $Source: /opt/cvsroot/erserver/src/com/postgres/replic/tools/desc/AddMarkerKeyColumn.java,v $
 * $Author: ronz $ $Revision: 1.1.1.1 $ $Date: 2003/10/21 13:01:38 $
 *
 */

package com.postgres.replic.tools.desc;

import com.postgres.replic.tools.*;
import java.sql.*;

public class AddMarkerKeyColumn extends GeneratorDescriptor {
    public static final String COL_NAME = "key";
    private SequenceDesc seqDesc;
    protected int mode = T_NO;

    public static final int ADD_COLUMN = 1;
    public static final int SET_DEFAULT = 2;

    public AddMarkerKeyColumn(boolean print) throws Exception {
        this(print, ADD_COLUMN);
    }

    //public AddMarkerKeyColumn(boolean print, boolean master) throws Exception {
    //    this(print, master, ADD_COLUMN);
    //}

    public AddMarkerKeyColumn(boolean print,int mode) throws Exception{
        this.print = print;
        this.mode = mode;
        seqDesc = new SequenceDesc(print);
        validateMode();
    }

    private void validateMode() throws Exception {
        if (mode != ADD_COLUMN && mode != SET_DEFAULT) {
             throw new Exception("AddMarkerKeyColumn::validateMode: wrong mode=" +mode);
        }
    }


    public boolean tableOnly() {
        return true;
    }

    public String getColumnName(String table) throws Exception {
        if (table == null || table.trim().equals("")) {
            throw new Exception("AddMarkerKeyColumn::getColumnName: table name may not be empty!" );
        }

        return ToolKitConst.GLOBAL_PREFIX + COL_NAME;

    }


    public String getLine(String table) throws Exception {
        if (table.toLowerCase().startsWith(ToolKitConst.GLOBAL_PREFIX)) {
            return "";
        }

        String result = null;

        if (mode == ADD_COLUMN) {
            String altTable = "alter table " + table + " add "
                 +  getColumnName(table) + " char(32);" ;
            result = altTable;
            if (print) System.out.println(altTable);
        }

        if (mode == SET_DEFAULT) {
             String altColumn = "alter table " + table + " alter column "
            +  getColumnName(table) + " set DEFAULT '"
            +  table + "';";
            if (print) System.out.println(altColumn);
            result = altColumn;
        }

        return result;

    }
}
