<?php
// english grammar module
// ramanraj@vsnl.com 2003-07-27

$vowels = 'aeiou';
$consonants = 'bcdfghjklmnpqrstvwxyz';

function get_plural($singular){
    // returns plural of $singular

    global $vowels;
    global $consonants;   
    $s = trim($singular);
    $s_lc = strtolower($s);

    // same word denoting both singular and plural
    $plural_used_as_singular  = array ('mathematics', 'physics', 'mechanics', 'politics',
				       'news', 'innings');
    $singular_used_as_plural  = array ('poultry', 'cattle', 'vermin', 'people', 'gentry');
    $same_singular_and_plural = array ('swine', 'sheep', 'deer', 'cod', 'trout', 'salmon',
				       'pair', 'dozen', 'score', 'gross', 'hundred', 'thousand',
                                       'alms', 'riches', 'eaves');
    $same_words = array_merge($plural_used_as_singular, $singular_used_as_plural, 
                              $same_singular_and_plural);
    while (list($key, $value)=each($same_words)){
	if ($value == $s_lc){
	    return $value;
	}
    }

    // check for special words
    $special_words = array('man'=>'men','woman'=>'women', 'foot'=>'feet','tooth'=>'teeth',
                           'goose'=>'geese','mouse'=>'mice','louse'=>'lice', 'ox'=>'oxen', 
                           'child'=>'children', 'erratum'=>'errata', 'index'=>'indices',
                           'radius'=>'radii', 'formula'=>'formulae', 'memorandum'=>'memoranda',
                           'terminus'=>'terminii', 'axis'=>'axes', 'crisis'=>'crises',
                           'basis'=>'bases', 'analysis'=>'analyses', 'paranthesis'=>'parentheses',
                           'hypothesis'=>'hypotheses', 'phenomenon'=>'phenomena', 
                           'criterion'=>'criteria', 'commander-in-chief'=>'commanders-in-chief',
			   'coat-of-mail'=>'coats-of-mail','son-in-law'=>'sons-in-law',
                           'daughter-in-law'=>'daughters-in-law', 'step-son'=>'step-sons',
                           'step-daughter'=>'step-daughters', 'maid-servant'=>'maid-servants',
                           'man-servant'=>'men-servants', 'passer-by'=>'passers-by',
                           'looker-on'=>'lookers-on', 'man-of-war'=>'men-of-war');
    while (list($key, $value) = each($special_words)){
	if ($key == $s_lc){
	    return $value;
	}
    }
    // check for special endings
    $special_ending = false;
    $endings = array('ss', 'sh', 'ch' , 'x', 'o', 'y', 'f', 'fe'); 
    $s_len = strlen($singular);
    $s_end_1= substr($s, -1, 1);
    $s_end_2= substr($s, -2, 2);
    while (list($key, $value)=each($endings)){
        $reg = $value . '$';
        $test = ereg( "$reg", $s_lc);
        if ($test == true){
            $special_ending = true;
            $ending_len = strlen($value);
	    switch ($value){
		case 'ss': 
                case 'sh':
		case 'ch':
		case 'x' :
		    $plural = $s . 'es';
		break;

		case 'o' :
		    $series_o = array('dynamo', 'canto', 'piano', 'solo', 'ratio', 'quarto', 'stereo');
		    while (list($k, $v)=each($series_o)){
			$o_test = ereg($v, $s);
			if ($o_test==true){
			    $special_ending=false;
			}
		    }
                    if ($special_ending==true){
			 $plural = $s . 'es';
		    }
		break;

                case 'y':
		    $s_end_2nd = substr($s, -2, 1);
		    $reg =  "$s_end_2nd";
		    $y_test = ereg("$reg", $consonants);
		    if ($y_test == true){ 
			$s_cut = substr($s, 0, -1);
			$plural = $s_cut . "ies";
		    } else {		   
			$special_ending=false;
		    }	        
                break;
		
		case 'f':
		case 'fe':
		    $series_f = array('chief', 'roof', 'gulf', 'grief', 'dwarf', 'safe', 'serf', 'brief',                                       'hoof', 'proof', 'strife', 'belief');		    
		    while (list($k, $v)=each($series_f)){
			$f_test = ereg($v, $s);
			if ($f_test==true){
			    $special_ending=false;
			}
		    }
                    if ($special_ending==true){
			$s_cut = substr($s, 0, -$ending_len);
			$plural = $s_cut . "ves";
		    }
		break;

            }
	}	
    }
    // if none of the special endings are found
    if (($s_len > 0) && ($special_ending==false)){
	if ($s_len==1){
	    $plural = $s . '\'s';
	}  else {
	    $plural = $s . 's';
        }
    }
    return $plural;
}
	
function get_feminine_gender($masculine){
    // returns feminine gender for masculine 
    $m = trim($masculine);
    $m_lc = strtolower($m);
    // special words for masculine and feminine gender
    $humans = array('man'=>'woman', 'father'=>'mother','boy'=>'girl', 'brother'=>'sister',
		     'uncle'=>'aunt', 'husband'=>'wife', 'nephew'=>'niece',
		     'bachelor'=>'spinster', 'gentleman'=>'lady', 'sir'=>'madam',
		     'king'=>'queen', 'lord'=>'lady', 'papa'=>'mamma', 'son'=>'daughter',
		     'wizard'=>'witch', 'hero'=>'heroine', 'administrator'=>'administratrix',
		     'executor'=>'executrix', 'testator'=>'testatrix', 'czar'=>'czarina',
		     'sultan'=>'sultana', 'signor'=>'signora', 'man-servant'=>'maid-servant',
		     'grand-father'=>'grand-mother','great-uncle'=>'great-aunt',
		     'land-lord'=>'land-lady', 'milk-man'=>'milk-maid',
		     'washer-man'=>'washer-woman', 'actor'=>'actress', 'benefactor'=>'benefactress',
		     'conductor'=>'conductress', 'enchanter'=>'enchantress', 'founder'=>'foundress',
                     'hunter'=>'huntress', 'instructor'=>'instructress',  'abbot'=>'abbess', 
                     'emperor'=>'empress', 'preceptor'=>'preceptress',  'songster'=>'songstress', 
		     'tempter'=>'temptress', 'seamster'=>'seamstress', 'tiger'=>'tigress', 
		     'traitor'=>'traitress', 'waiter'=>'waitress', 'master'=>'mistress',
                     'murderer'=>'murderess', 'sorcerer'=>'sorceress' ,'negro'=>'negress', 
                     'duke'=>'duchess', 'prince'=>'princess','marquis'=>'marchioness');
    $animals = array('cock'=>'hen', 'dog'=>'bitch', 'buck'=>'doe', 'bull'=>'cow', 'bullock'=>'heifer',
                     'drake'=>'duck', 'drone'=>'bee', 'gander'=>'goose', 'hart'=>'roe', 'horse'=>'mare',
		     'ram'=>'ewe', 'stag'=>'hind', 'fox'=>'vixen', 'bull-calf'=>'cow-calf', 
		     'he-goat'=>'she-goat', 'cock-sparrow'=>'hen-sparrow', 'he-bear'=>'she-bear',
		     'jack-ass'=>'jenny-ass', 'pea-cock'=>'pea-hen');
    $special_words = array_merge($humans, $animals);
    while (list($key, $value)=each($special_words)){
	if ($key == $m_lc){
	    return $value;
	}
    }
    
    // feminine form by adding syllable -ess
    $add_ess_nouns = array ('author', 'baron', 'count', 'giant', 'heir', 'host', 'jew', 'lion',
			    'manager', 'mayor', 'patron', 'peer', 'poet', 'priest', 'prophet',
			    'shepherd', 'steward', 'viscount');
    while (list($key, $value)=each($add_ess_nouns)){
	if ($value==$m_lc){
            $fem = $value . 'ess';
            return $fem;
        }
    }
}


$test = array('boy', 'man', 'drake', 'king');
while (list($key, $value)=each($test)){
    $result = get_feminine_gender($value);
    echo "<p>$value : $result";
}
$test = array('boy','baby', 'girl', 'cow', 'box', 'class', 'tax', 'hero', 'echo', 'volcano', 'match', 'Thief', 'life', 'wife', 'knife', 'wolf', 'chief', 'man', 'goose', 'a', '', 'loaf', 'shelf', 'mouse', 'louse', 'ox', 'child', 'foot', 'tooth', 'proof', 'computer', 'diskette', 'light', 'mathematics');
while (list($key, $value)=each($test)){
    $result = get_plural($value);
    echo "<p>$value : $result";
}

?>

