<?php
$IND_NUM2WORDS = TRUE;
//Author: K. Ramanraj, 30th August 2001.
//Function: string ind_num2words($num)
//	Object: Express a given number $num in words in Indian style.
//	Range : Max=Ninety Nine Lakh Ninety Nine Thousand Nine Hundred and Ninety Nine Crore Ninety Nine Lakh Ninety Nine Thousand Nine Hundred and Ninety Nine [99,99,999,99,99,999].  Returns empty string if number is beyond range.
//  Validation: Function strips all text and punctuation marks except numbers and decimal point while processing.
//Function: string ind_fmt_num($num)
function num_basic($num){
		$num = (integer)$num;
 		$num_word[0] = '';
    $num_word[1] = 'One';
    $num_word[2] = 'Two';
    $num_word[3] = 'Three';
    $num_word[4] = 'Four';
    $num_word[5] = 'Five';
    $num_word[6] = 'Six';
    $num_word[7] = 'Seven';
    $num_word[8] = 'Eight';
    $num_word[9] = 'Nine';
    $num_word[10] = 'Ten';
    $num_word[11] = 'Eleven';
    $num_word[12] = 'Twelve';
    $num_word[13] = 'Thirteen';
    $num_word[14] = 'Fourteen';
    $num_word[15] = 'Fifteen';
    $num_word[16] = 'Sixteen';
    $num_word[17] = 'Seventeen';
    $num_word[18] = 'Eighteen';
    $num_word[19] = 'Nineteen';
    $num_word[20] = 'Twenty';
    $num_word[30] = 'Thirty';
    $num_word[40] = 'Forty';
    $num_word[50] = 'Fifty';
    $num_word[60] = 'Sixty';
    $num_word[70] = 'Seventy';
    $num_word[80] = 'Eighty';
    $num_word[90] = 'Ninety';
		if ($num < 21){
			$result = $num_word[$num];
			} elseif (($num > 20) && ($num < 100)){
			$tens = substr($num, 0, 1);
			$units = substr($num, 1, 1);
			$tens .= '0';
			$tens = $num_word[$tens];
			$units = $num_word[$units];
			$result = $tens . ' ' . $units;
		}		
		return $result;
}

function num_hund($num){
	$num = (integer)$num;
	if ($num < 100){
		$result = num_basic($num);
		} else {
		$basic = (integer) substr($num, 1, 2);
		$hund = (integer) substr($num, 0, 1);
		$hund_words=num_basic($hund);
		$basic_words =num_basic($basic);
		if ($basic_words!=''){
			$result = $hund_words . ' Hundred and ' . $basic_words;
			} else {
			$result = $hund_words . ' Hundred ' . $basic_words;
		}
	}
	return $result;
}

function num_thou($num){
	$num = (integer)$num;
	if ($num < 100){
		$result = num_basic($num);
		} elseif(($num >100) && ($num <1000)){
		$num = (integer)$num;
		$result = num_hund($num);
		} else {
		$num=(integer)$num;
		$num_length=strlen($num);
		$hund = (integer)substr($num, -3, 3);
		if ($num_length==4){
			$thou = (integer) substr($num, 0, 1);
			} elseif ($num_length==5){
			$thou = (integer) substr($num, 0, 2);
		}
		$hund_words=num_hund($hund);
		$thou_words =num_basic($thou);
		$result = $thou_words . ' Thousand ' . $hund_words;
	}
	return $result;
}
function num_lakh($num){
	$num = (integer)$num;
	if ($num < 100){
		$result = num_basic($num);
		} elseif(($num > 99) && ($num <1000)){
		$result = num_hund($num);
		} elseif(($num > 999) && ($num < 100000)) {
		$result = num_thou($num);
		} else {
		$num_length=strlen($num);
		$thou =  substr($num, -5, 5);
		if ($num_length==6){
			$lakh = (integer) substr($num, 0, 1);
			} else {
			$lakh = (integer) substr($num, 0, 2);
		}
		$thou_words=num_thou($thou);
		$lakh_words =num_basic($lakh);
		$result = $lakh_words . ' Lakh ' . $thou_words;
	}
	return $result;
}
function ind_num2words($num){
	$num = ereg_replace("[A-Za-z,]", '',$num);
        $num = (double)$num;
	$num_length=strlen($num);
	switch ($num_length){
		case 1:
			$result = num_basic($num);
			break;
		case 2:
			$result = num_basic($num);
			break;
		case 3:
			$result = num_hund($num);
			break;
		case 4:
			$result = num_thou($num);
			break;
		case 5:
			$result = num_thou($num);
			break;
		case 6:
			$result = num_lakh($num);
			break;
		case 7:
			$result = num_lakh($num);
			break;
		default:
			if (($num_length>7) && ($num_length < 15)){
				$crore_part = $num_length -7;
				$crore = (integer)substr($num,0,$crore_part);
				$lakh = substr($num, -7, 7);
				$result = num_lakh($crore) . ' Crore ' . num_lakh($lakh);
				} else {
				$result = "$num is too big";

			}
			break;
	}
		return $result;
}
	
if (!isset($num)){
	$num=0;
}
/*
echo "<html>";
echo "<FORM action=\"test_num2words.php\" method=\"post\"></form>";
echo "<input type=\"text\" name=\"num\" size=\"50\" maxlength=\"100\" value=$num>";
echo "<input type=\"submit\" name=\"submit\" value=\"submit\">";


$result = ind_num2words($num);
echo "<p>$result";
*/
?>



