.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "SELECT INTO" "" "2004-10-09" "SQL - Language Statements" "SQL Commands"
.SH NAME
SELECT INTO \- define a new table from the results of a query

.SH SYNOPSIS
.sp
.nf
SELECT [ ALL | DISTINCT [ ON ( \fIexpression\fR [, ...] ) ] ]
    * | \fIexpression\fR [ AS \fIoutput_name\fR ] [, ...]
    INTO [ TEMPORARY | TEMP ] [ TABLE ] \fInew_table\fR
    [ FROM \fIfrom_item\fR [, ...] ]
    [ WHERE \fIcondition\fR ]
    [ GROUP BY \fIexpression\fR [, ...] ]
    [ HAVING \fIcondition\fR [, ...] ]
    [ { UNION | INTERSECT | EXCEPT } [ ALL ] \fIselect\fR ]
    [ ORDER BY \fIexpression\fR [ ASC | DESC | USING \fIoperator\fR ] [, ...] ]
    [ LIMIT { \fIcount\fR | ALL } ]
    [ OFFSET \fIstart\fR ]
    [ FOR UPDATE [ OF \fItablename\fR [, ...] ] ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBSELECT INTO\fR creates a new table and fills it
with data computed by a query. The data is not returned to the
client, as it is with a normal \fBSELECT\fR. The new
table's columns have the names and data types associated with the
output columns of the \fBSELECT\fR.
.SH "PARAMETERS"
.TP
\fBTEMPORARY or TEMP\fR
If specified, the table is created as a temporary table. Refer
to CREATE TABLE [\fBcreate_table\fR(l)] for details.
.TP
\fB\fInew_table\fB\fR
The name (optionally schema-qualified) of the table to be created.
.PP
All other parameters are described in detail under SELECT [\fBselect\fR(l)].
.PP
.SH "NOTES"
.PP
CREATE TABLE AS [\fBcreate_table_as\fR(l)] is functionally similar to
\fBSELECT INTO\fR. \fBCREATE TABLE AS\fR
is the recommended syntax, since this form of \fBSELECT
INTO\fR is not available in \fBECPG\fR
or \fBPL/pgSQL\fR, because they interpret the
INTO clause differently. Furthermore,
\fBCREATE TABLE AS\fR offers a superset of the
functionality provided by \fBSELECT INTO\fR.
.PP
Prior to PostgreSQL 8.0, the table created by
\fBSELECT INTO\fR always included OIDs. Furthermore,
these OIDs were newly generated: they were distinct from the OIDs
of any of the rows in the source tables of the \fBSELECT
INTO\fR statement. Therefore, if \fBSELECT
INTO\fR was frequently executed, the OID counter would be
rapidly incremented. As of PostgreSQL 8.0, the
inclusion of OIDs in the table created by \fBSELECT
INTO\fR is controlled by the
[XRef to GUC-DEFAULT-WITH-OIDS] configuration variable. This
variable currently defaults to true, but will likely default to
false in a future release of PostgreSQL.
.SH "COMPATIBILITY"
.PP
The SQL standard uses \fBSELECT INTO\fR to
represent selecting values into scalar variables of a host program,
rather than creating a new table. This indeed is the usage found
in \fBECPG\fR (see [XRef to ECPG]) and
\fBPL/pgSQL\fR (see [XRef to PLPGSQL]).
The PostgreSQL usage of \fBSELECT
INTO\fR to represent table creation is historical. It is
best to use \fBCREATE TABLE AS\fR for this purpose in
new code.
