.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "FETCH" "" "2004-10-09" "SQL - Language Statements" "SQL Commands"
.SH NAME
FETCH \- retrieve rows from a query using a cursor

.SH SYNOPSIS
.sp
.nf
FETCH [ \fIdirection\fR { FROM | IN } ] \fIcursorname\fR

where \fIdirection\fR can be empty or one of:

    NEXT
    PRIOR
    FIRST
    LAST
    ABSOLUTE \fIcount\fR
    RELATIVE \fIcount\fR
    \fIcount\fR
    ALL
    FORWARD
    FORWARD \fIcount\fR
    FORWARD ALL
    BACKWARD
    BACKWARD \fIcount\fR
    BACKWARD ALL
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBFETCH\fR retrieves rows using a previously-created cursor.
.PP
A cursor has an associated position, which is used by
\fBFETCH\fR. The cursor position can be before the first row of the
query result, on any particular row of the result, or after the last row
of the result. When created, a cursor is positioned before the first row.
After fetching some rows, the cursor is positioned on the row most recently
retrieved. If \fBFETCH\fR runs off the end of the available rows
then the cursor is left positioned after the last row, or before the first
row if fetching backward. \fBFETCH ALL\fR or \fBFETCH BACKWARD
ALL\fR will always leave the cursor positioned after the last row or before
the first row.
.PP
The forms NEXT, PRIOR, FIRST,
LAST, ABSOLUTE, RELATIVE fetch
a single row after moving the cursor appropriately. If there is no
such row, an empty result is returned, and the cursor is left
positioned before the first row or after the last row as
appropriate.
.PP
The forms using FORWARD and BACKWARD
retrieve the indicated number of rows moving in the forward or
backward direction, leaving the cursor positioned on the
last-returned row (or after/before all rows, if the \fIcount\fR exceeds the number of rows
available).
.PP
RELATIVE 0, FORWARD 0, and
BACKWARD 0 all request fetching the current row without
moving the cursor, that is, re-fetching the most recently fetched
row. This will succeed unless the cursor is positioned before the
first row or after the last row; in which case, no row is returned.
.SH "PARAMETERS"
.TP
\fB\fIdirection\fB\fR
\fIdirection\fR defines
the fetch direction and number of rows to fetch. It can be one
of the following:
.RS
.TP
\fBNEXT\fR
Fetch the next row. This is the default if \fIdirection\fR is omitted.
.TP
\fBPRIOR\fR
Fetch the prior row.
.TP
\fBFIRST\fR
Fetch the first row of the query (same as ABSOLUTE 1).
.TP
\fBLAST\fR
Fetch the last row of the query (same as ABSOLUTE -1).
.TP
\fBABSOLUTE \fIcount\fB\fR
Fetch the \fIcount\fR'th row of the query,
or the abs(\fIcount\fR)'th row from
the end if \fIcount\fR is negative. Position
before first row or after last row if \fIcount\fR is out of range; in
particular, ABSOLUTE 0 positions before
the first row.
.TP
\fBRELATIVE \fIcount\fB\fR
Fetch the \fIcount\fR'th succeeding row, or
the abs(\fIcount\fR)'th prior
row if \fIcount\fR is
negative. RELATIVE 0 re-fetches the
current row, if any.
.TP
\fB\fIcount\fB\fR
Fetch the next \fIcount\fR rows (same as
FORWARD \fIcount\fR).
.TP
\fBALL\fR
Fetch all remaining rows (same as FORWARD ALL).
.TP
\fBFORWARD\fR
Fetch the next row (same as NEXT).
.TP
\fBFORWARD \fIcount\fB\fR
Fetch the next \fIcount\fR rows.
FORWARD 0 re-fetches the current row.
.TP
\fBFORWARD ALL\fR
Fetch all remaining rows.
.TP
\fBBACKWARD\fR
Fetch the prior row (same as PRIOR).
.TP
\fBBACKWARD \fIcount\fB\fR
Fetch the prior \fIcount\fR rows (scanning
backwards). BACKWARD 0 re-fetches the
current row.
.TP
\fBBACKWARD ALL\fR
Fetch all prior rows (scanning backwards).
.RE
.PP
.TP
\fB\fIcount\fB\fR
\fIcount\fR is a
possibly-signed integer constant, determining the location or
number of rows to fetch. For FORWARD and
BACKWARD cases, specifying a negative \fIcount\fR is equivalent to changing
the sense of FORWARD and BACKWARD.
.TP
\fB\fIcursorname\fB\fR
An open cursor's name.
.SH "OUTPUTS"
.PP
On successful completion, a \fBFETCH\fR command returns a command
tag of the form
.sp
.nf
FETCH \fIcount\fR
.sp
.fi
The \fIcount\fR is the number
of rows fetched (possibly zero). Note that in
\fBpsql\fR, the command tag will not actually be
displayed, since \fBpsql\fR displays the fetched
rows instead.
.SH "NOTES"
.PP
The cursor should be declared with the SCROLL
option if one intends to use any variants of \fBFETCH\fR
other than \fBFETCH NEXT\fR or \fBFETCH FORWARD\fR with
a positive count. For simple queries
PostgreSQL will allow backwards fetch
from cursors not declared with SCROLL, but this
behavior is best not relied on. If the cursor is declared with
NO SCROLL, no backward fetches are allowed.
.PP
ABSOLUTE fetches are not any faster than
navigating to the desired row with a relative move: the underlying
implementation must traverse all the intermediate rows anyway.
Negative absolute fetches are even worse: the query must be read to
the end to find the last row, and then traversed backward from
there. However, rewinding to the start of the query (as with
FETCH ABSOLUTE 0) is fast.
.PP
Updating data via a cursor is currently not supported by
PostgreSQL.
.PP
DECLARE [\fBdeclare\fR(l)]
is used to define a cursor. Use
MOVE [\fBmove\fR(l)]
to change cursor position without retrieving data.
.SH "EXAMPLES"
.PP
The following example traverses a table using a cursor.
.sp
.nf
BEGIN WORK;

-- Set up a cursor:
DECLARE liahona SCROLL CURSOR FOR SELECT * FROM films;

-- Fetch the first 5 rows in the cursor liahona:
FETCH FORWARD 5 FROM liahona;

 code  |          title          | did | date_prod  |   kind   |  len
-------+-------------------------+-----+------------+----------+-------
 BL101 | The Third Man           | 101 | 1949-12-23 | Drama    | 01:44
 BL102 | The African Queen       | 101 | 1951-08-11 | Romantic | 01:43
 JL201 | Une Femme est une Femme | 102 | 1961-03-12 | Romantic | 01:25
 P_301 | Vertigo                 | 103 | 1958-11-14 | Action   | 02:08
 P_302 | Becket                  | 103 | 1964-02-03 | Drama    | 02:28

-- Fetch the previous row:
FETCH PRIOR FROM liahona;

 code  |  title  | did | date_prod  |  kind  |  len
-------+---------+-----+------------+--------+-------
 P_301 | Vertigo | 103 | 1958-11-14 | Action | 02:08

-- Close the cursor and end the transaction:
CLOSE liahona;
COMMIT WORK;
.sp
.fi
.SH "COMPATIBILITY"
.PP
The SQL standard defines \fBFETCH\fR for use in
embedded SQL only. The variant of \fBFETCH\fR
described here returns the data as if it were a
\fBSELECT\fR result rather than placing it in host
variables. Other than this point, \fBFETCH\fR is
fully upward-compatible with the SQL standard.
.PP
The \fBFETCH\fR forms involving
FORWARD and BACKWARD, as well
as the forms FETCH \fIcount\fR and FETCH
ALL, in which FORWARD is implicit, are
PostgreSQL extensions.
.PP
The SQL standard allows only FROM preceding the cursor
name; the option to use IN is an extension.
