/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kgenericfactory.h>

// WorKflow includes
#include <workflow/applicationfactory.h>
#include <workflow/commandfactory.h>

// library includes
#include "katelibrary.h"

// application
#include "kateapplication.h"

// commands
#include "getactivekatedocumentcommand.h"
#include "getallkatedocumentscommand.h"
#include "getfulltextfromkatecommand.h"
#include "getselectedtextfromkatecommand.h"
#include "setfulltextinkatecommand.h"
#include "setselectedtextinkatecommand.h"
#include "openfilesinkatecommand.h"
#include "inserttextinkatecommand.h"

using namespace WorKflow;

typedef KGenericFactory<KateLibrary> Factory;
K_EXPORT_COMPONENT_FACTORY(libworkflow_katecommands, Factory("workflow_katecommands"))

KateLibrary::KateLibrary(QObject* parent, const char* name, const QStringList& args)
  : Library(parent, name, args)
{
}

void KateLibrary::init()
{
  addApplicationFactory(new ApplicationFactory<KateApplication>("org.kde.kate"));

  addCommandFactory(new CommandFactory<GetActiveKateDocumentCommand>("org.kde.Kate.GetActiveKateDocument"));
  addCommandFactory(new CommandFactory<GetAllKateDocumentsCommand>("org.kde.Kate.GetAllKateDocuments"));
  addCommandFactory(new CommandFactory<GetFullTextFromKateCommand>("org.kde.Kate.GetFullTextFromKate"));
  addCommandFactory(new CommandFactory<GetSelectedTextFromKateCommand>("org.kde.Kate.GetSelectedTextFromKate"));
  addCommandFactory(new CommandFactory<SetFullTextInKateCommand>("org.kde.Kate.SetFullTextInKate"));
  addCommandFactory(new CommandFactory<SetSelectedTextInKateCommand>("org.kde.Kate.SetSelectedTextInKate"));
  addCommandFactory(new CommandFactory<OpenFilesInKateCommand>("org.kde.Kate.OpenFilesInKate"));
  addCommandFactory(new CommandFactory<InsertTextInKateCommand>("org.kde.Kate.InsertTextInKate"));
}

#include "katelibrary.moc"
