/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// WorKflow includes
#include <workflow/document.h>
#include <workflow/applicationmanager.h>

// command includes
#include "inserttextinkatecommand.h"
#include "inserttextinkatewidget.h"
#include "kateapplication.h"

using namespace WorKflow;

InsertTextInKateCommand::InsertTextInKateCommand(Document* parent, CommandDescription* description)
  : Command(parent, description)
{
  InsertTextInKateWidget* w = new InsertTextInKateWidget(this);
  setWidget(w);
}

InsertTextInKateCommand::~InsertTextInKateCommand()
{
}

void InsertTextInKateCommand::execute()
{
  QStringList input = value("input").asStringList();
  QString pos = value("position").enumKey();

  KateApplication::InsertPosition position =
       (pos == "current" ? KateApplication::CursorPosition :
        pos == "start" ? KateApplication::StartOfDocument : KateApplication::EndOfDocument);

  Application* app = document()->appManager()->findRunning("org.kde.kate");
  if (app) {
    KateApplication* kate = static_cast<KateApplication*>(app);

    QString original = kate->currentText();

    // for one line of input, don't add an extra newline at the end
    if (input.count() > 1)
      kate->insertText(input.join("\n") + '\n', position);
    else
      kate->insertText(input.join("\n"), position);

    QString newtext = kate->currentText();

    setResult("original", Value::stringList("org.kde.public.text", QStringList::split('\n', original, true)));
    setResult("newtext", Value::stringList("org.kde.public.text", QStringList::split('\n', newtext, true)));
  } else {
    // error
  }

  Command::execute();
}

#include "inserttextinkatecommand.moc"
