/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// WorKflow includes
#include <workflow/document.h>
#include <workflow/applicationmanager.h>

// command includes
#include "getselectedtextfromkatecommand.h"
#include "getselectedtextfromkatewidget.h"
#include "kateapplication.h"

using namespace WorKflow;

GetSelectedTextFromKateCommand::GetSelectedTextFromKateCommand(Document* parent, CommandDescription* description)
  : Command(parent, description)
{
  GetSelectedTextFromKateWidget* w = new GetSelectedTextFromKateWidget(this);
  setWidget(w);
}

GetSelectedTextFromKateCommand::~GetSelectedTextFromKateCommand()
{
}

void GetSelectedTextFromKateCommand::execute()
{
  bool allIfNoSelection = value("allifnoselection").nextBoolean();

  Application* app = document()->appManager()->findRunning("org.kde.kate");
  if (app) {
    KateApplication* kate = static_cast<KateApplication*>(app);
    QString text = kate->selectedText();
    if (text.isNull() && allIfNoSelection)
      text = kate->currentText();
    setResult("output", Value::stringList("org.kde.public.text", QStringList::split('\n', text, true)));
  } else {
    // error
  }
}

#include "getselectedtextfromkatecommand.moc"
