/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef FILENAMEFILTERWIDGET_H
#define FILENAMEFILTERWIDGET_H

#include "widgetinterface.h"

// #include "filenamefilterwidgetbase.h"

class QComboBox;
class QPushButton;

namespace WorKflow
{
  class FilenameFilterWidget : public QWidget, public WorKflow::WidgetInterface
  {
    Q_OBJECT
    Q_PROPERTY(QString parameterId READ parameterId WRITE setParameterId)

  public:
    FilenameFilterWidget(QWidget* parent = 0, const char* name = 0, WFlags fl = 0);
    ~FilenameFilterWidget();

    virtual Value value();

    virtual void setParameterId(const QString& paramId);
    virtual QString parameterId() const;

  public slots:
    virtual void setValue(const Value& value);

  private slots:
    void slotChanged();

  signals:
    void changed(const Value& value);

  protected slots:
    virtual void editFilter();

  private:
    QComboBox* m_comboBox;
    QPushButton* m_editButton;

    QMap<QString, QString> m_filters;
    QStringList m_value;
  };
}

#endif

