/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// Qt includes
#include <qpainter.h>

// STL includes
#include <algorithm>
  using std::max;

// WorKflow includes
#include "cornerwidget.h"

using namespace WorKflow;

CornerWidget::CornerWidget(QWidget* parent, const char* name)
  : QWidget(parent, name)
{
  setPaletteBackgroundColor(Qt::white);
  fontChange(font());
}

CornerWidget::~CornerWidget()
{
}

void CornerWidget::drawBackground(QPainter* p, bool left)
{
  p->setPen(Qt::lightGray);
  p->setBrush(Qt::lightGray);

  if (left)
    p->drawRect(width() / 2, 0, width(), height());
  else
    p->drawRect(0, 0, width() / 2, height());

  p->setPen(Qt::darkGray);
  p->setBrush(Qt::darkGray);
  p->drawEllipse(rect());
  p->drawRect(0, height() / 2, width(), height());
}

void CornerWidget::drawInner(QPainter* p, const QColor& color)
{
  p->setPen(color);
  p->setBrush(color);
  p->drawEllipse(5, 5, width() - 10, height() - 10);
}

void CornerWidget::drawText(QPainter* p, const QString& text)
{
  // TODO: make prettier
  QFont f = p->font();
  f.setBold(true);
  p->setFont(f);

  QFontMetrics m(f);

  QPoint offset(m.width(text) / 2, - m.height() / 2);
  QPoint pos = rect().center() - offset;

  p->setPen(Qt::blue);
  p->drawText(pos, text);
}

// This is just the 3rd day of SoC and it's my first dirty hack ... :)
// Together, these methods ensure that the widget looks proper at all
// times.
void CornerWidget::fontChange(const QFont&)
{
  setMinimumSize(1, 1);
}

void CornerWidget::resizeEvent(QResizeEvent*)
{
  int h = max(height(), 28);
  setMinimumSize(h, h);
}

void CornerWidget::setSelected(bool selected)
{
  if (selected) {
    setPaletteBackgroundColor(Qt::blue);
  } else {
    setPaletteBackgroundColor(Qt::white);
  }
}

#include "cornerwidget.moc"
