/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <klocale.h>
#include <kdebug.h>

// Qt includes
#include <qdragobject.h>
#include <qheader.h>

// WorKflow includes
#include "commandlistview.h"
#include "commandlistviewitem.h"
#include "commandmanager.h"
#include "commanddescription.h"
#include "commanddrag.h"

using namespace WorKflow;

CommandListView::CommandListView(QWidget* parent, const char* name)
  : KListView(parent, name)
{
  addColumn(i18n("Command"));
  addColumn("");
  setColumnWidthMode(1, Manual);
  hideColumn(1);
  header()->setResizeEnabled(false, 1);
  setDragEnabled(true);

  connect(this, SIGNAL(doubleClicked(QListViewItem*)), this, SLOT(slotExecuted(QListViewItem*)));
  connect(this, SIGNAL(selectionChanged(QListViewItem*)), this, SLOT(slotSelectionChanged(QListViewItem*)));
}

CommandListView::~CommandListView()
{
}

QString CommandListView::category()
{
  return m_category;
}

void CommandListView::setCategory(const QString& category)
{
  if (category != m_category) {
    m_category = category;
    populate();
  }
}

void CommandListView::populate()
{
//   kdDebug() << k_funcinfo << " Category: " << m_category << endl;

  typedef CommandManager::DescriptionList DescList;

  clear();
  DescList commands;
  if (!m_category.isEmpty())
    commands = CommandManager::self()->commands(m_category);
  else
    commands = CommandManager::self()->allCommands();

  for (DescList::ConstIterator i = commands.begin(); i != commands.end(); ++i) {
    if ((*i)->isHidden())
      continue;

    CommandListViewItem* item = new CommandListViewItem(this, *i);
    item->setDragEnabled(true);
    insertItem(item);
  }
}

QDragObject* CommandListView::dragObject()
{
  kdDebug() << k_funcinfo << endl;

  CommandListViewItem* item = static_cast<CommandListViewItem*>(selectedItem());
  if (item) {
    CommandDrag* drag = new CommandDrag(CommandDrag::Info(item->commandDescription()->id()), viewport());
//     QTextDrag* drag = new QTextDrag(item->commandFactory()->id(), viewport());
//     drag->setSubtype("x-workflowcommand");
    return drag;
  }
  return 0;
}

void CommandListView::slotExecuted(QListViewItem* item)
{
  CommandListViewItem* cmdItem = static_cast<CommandListViewItem*>(item);
  if (cmdItem) {
    emit executed(cmdItem->commandDescription()->id());
  }
}

void CommandListView::slotSelectionChanged(QListViewItem* item)
{
  if (!item)
    return;

  CommandListViewItem* cmdItem = static_cast<CommandListViewItem*>(item);
  emit selected(cmdItem->commandDescription());
}

#include "commandlistview.moc"
