/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// Qt includes
#include <qpainter.h>

// STL includes
#include <algorithm>
  using std::max;

// WorKflow includes
#include "collapsewidget.h"

using namespace WorKflow;

CollapseWidget::CollapseWidget(QWidget* parent, const char* name, WFlags f)
  : QWidget(parent, name, f), m_collapsed(false)
{
  setPaletteBackgroundColor(Qt::lightGray);
  fontChange(font());
}

CollapseWidget::~CollapseWidget()
{
}

bool CollapseWidget::isCollapsed()
{
  return m_collapsed;
}

void CollapseWidget::setCollapsed(bool collapsed)
{
  if (m_collapsed != collapsed) {
    m_collapsed = collapsed;
    update();
    emit toggled(collapsed);
  }
}

void CollapseWidget::paintEvent(QPaintEvent*)
{
  QPainter p(this);
  p.setPen(Qt::white);
  p.setBrush(Qt::white);

  int arrowSize = 15;
  int topLeft = (height() - arrowSize) / 2;
  int middle = topLeft + arrowSize / 2;
  int bottomRight = topLeft + arrowSize;

  QPointArray array;

  if (m_collapsed) {
    // >
    array.putPoints(0, 3, topLeft, topLeft, topLeft, bottomRight, bottomRight, middle);
  } else {
    // V
    array.putPoints(0, 3, topLeft, topLeft, bottomRight, topLeft, middle, bottomRight);
  }

  p.drawPolygon(array);
}

void CollapseWidget::mousePressEvent(QMouseEvent* e)
{
  if (e->button() & Qt::LeftButton) {
    setCollapsed(!isCollapsed());
    e->accept();
  }
}

void CollapseWidget::fontChange(const QFont&)
{
  setMinimumSize(1, 1);
}

void CollapseWidget::resizeEvent(QResizeEvent*)
{
  int h = max(height(), 28);
  setMinimumSize(h, h);
}

#include "collapsewidget.moc"
