/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// Qt includes
#include <qpainter.h>

// WorKflow includes
#include "closewidget.h"

using namespace WorKflow;

CloseWidget::CloseWidget(QWidget* parent, const char* name)
  : CornerWidget(parent, name), m_hover(false), m_pressed(false)
{

}

CloseWidget::~CloseWidget()
{
}

void CloseWidget::paintEvent(QPaintEvent*)
{
  QPainter p(this);

  drawBackground(&p, false);

  QColor color;
  if (!m_hover)
    color = Qt::white;
  else if (m_pressed)
    color = Qt::darkGray;
  else
    color = Qt::lightGray;

  drawInner(&p, color);
  drawText(&p, "X");
}

void CloseWidget::mousePressEvent(QMouseEvent*)
{
  m_pressed = true;
  update();
}

void CloseWidget::mouseReleaseEvent(QMouseEvent* e)
{
  if (rect().contains(e->pos()))
    emit clicked();

  m_pressed = false;
  update();
}

void CloseWidget::enterEvent(QEvent*)
{
  m_hover = true;
  update();
}

void CloseWidget::leaveEvent(QEvent*)
{
  m_hover = false;
  update();
}

#include "closewidget.moc"
