/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

// KDE includes
#include <kmainwindow.h>

// Qt includes

// WorKflow includes

// forward declarations
class KAction;
class EditWidget;
class LibraryWidget;
class IoWidget;

namespace WorKflow
{
  class LibraryDescription;
}

/**
 * @author Thomas Kadauke
 */
class MainWindow : public KMainWindow
{
  Q_OBJECT

public:
  MainWindow();
  ~MainWindow();

protected:
  void setupActions();

private slots:
  void newLibrary();
  void open();
  void save();
  void saveAs();
  void loadLibraries();

private:
  void setLibrary(WorKflow::LibraryDescription* library);
  MainWindow* newWindow();

  QString m_filename;

  WorKflow::LibraryDescription* m_library;

  EditWidget* m_editWidget;
  LibraryWidget* m_libraryWidget;
  IoWidget* m_ioWidget;

  KAction* m_loadLibraries;
};

#endif
