/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef DATATYPEDIALOG_H
#define DATATYPEDIALOG_H

#include "datatypedialogbase.h"

// forward declarations
namespace WorKflow
{
  class CategoryDescription;
  class LibraryDescription;
  class Datatype;
}

class DatatypeDialog : public DatatypeDialogBase
{
  Q_OBJECT

public:
  static bool editDatatype(QWidget* parent, WorKflow::Datatype* desc);
  static WorKflow::Datatype* newDatatype(QWidget* parent, WorKflow::LibraryDescription* library);

protected:
  DatatypeDialog(QWidget* parent, WorKflow::Datatype* desc);
  ~DatatypeDialog();

  void init();

protected slots:
  virtual void accept();
  virtual void addItem();
  virtual void removeItem();
  virtual void itemUp();
  virtual void itemDown();
  virtual void slotItemSelectionChanged();
  virtual void updateItem();
  virtual void getBaseType();

private:
  WorKflow::Datatype* m_datatype;
  bool m_dontUpdate;
};

#endif

