/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <klocale.h>
#include <klistview.h>
#include <kpushbutton.h>

// Qt includes
#include <qlineedit.h>
#include <qgroupbox.h>

// WorKflow includes
#include "datatype.h"

// designer includes
#include "datatypedialog.h"
#include "dialoghelper.h"
#include "selecttypedialog.h"

using namespace WorKflow;

bool DatatypeDialog::editDatatype(QWidget* parent, Datatype* desc)
{
  DatatypeDialog dialog(parent, desc);
  return dialog.exec();
}

Datatype* DatatypeDialog::newDatatype(QWidget* parent, LibraryDescription* library)
{
  Datatype* type = new Datatype(library);

  DatatypeDialog dialog(parent, type);
  if (dialog.exec())
    return dialog.m_datatype;
  else
    delete type;
  return 0;
}

DatatypeDialog::DatatypeDialog(QWidget* parent, Datatype* desc)
  : DatatypeDialogBase(parent), m_datatype(desc), m_dontUpdate(false)
{
  init();
}

DatatypeDialog::~DatatypeDialog()
{
}

void DatatypeDialog::init()
{
  m_idEdit->setText(m_datatype->id());
  m_nameEdit->setText(m_datatype->name());
  m_pluralNameEdit->setText(m_datatype->pluralName());
  m_descriptionEdit->setText(m_datatype->description());
  m_baseTypeEdit->setText(m_datatype->baseTypeId());

  m_enumGroupBox->setChecked(m_datatype->isEnum());

  m_enumItemsListView->setSorting(-1);
  QStringList enumKeys = m_datatype->enumKeys();
  QStringList enumNames = m_datatype->enumNames();

  QStringList::ConstIterator k = enumKeys.begin();
  QStringList::ConstIterator n = enumNames.begin();

  for ( ; k != enumKeys.end(); ++k, ++n) {
    new KListViewItem(m_enumItemsListView, m_enumItemsListView->lastItem(), *k, *n);
  }
}

void DatatypeDialog::accept()
{
  m_datatype->setId(m_idEdit->text());
  m_datatype->setName(m_nameEdit->text());
  m_datatype->setPluralName(m_pluralNameEdit->text());
  m_datatype->setDescription(m_descriptionEdit->text());
  m_datatype->setBaseTypeId(m_baseTypeEdit->text());

  m_datatype->clearEnumItems();
  if (m_enumGroupBox->isChecked()) {
    QListViewItemIterator it(m_enumItemsListView);
    while (it.current()) {
      m_datatype->addEnumItem(it.current()->text(0), it.current()->text(1));
      ++it;
    }
  }

  QDialog::accept();
}

void DatatypeDialog::addItem()
{
  KListViewItem* item = new KListViewItem(m_enumItemsListView, m_enumItemsListView->lastItem(), i18n("<Key>"), i18n("<Value>"));
  m_enumItemsListView->setSelected(item, true);
  m_enumKeyEdit->selectAll();
}

void DatatypeDialog::removeItem()
{
  DialogHelper::removeItem(m_enumItemsListView);
}

void DatatypeDialog::itemUp()
{
  DialogHelper::itemUp(m_enumItemsListView);
}

void DatatypeDialog::itemDown()
{
  DialogHelper::itemDown(m_enumItemsListView);
}

void DatatypeDialog::slotItemSelectionChanged()
{
  QListViewItem* item = m_enumItemsListView->selectedItem();
  m_removeItemButton->setEnabled(item != 0);
  m_itemUpButton->setEnabled(item != 0 && item->itemAbove() != 0);
  m_itemDownButton->setEnabled(item != 0 && item->itemBelow() != 0);
  m_editItemGroupBox->setEnabled(item != 0);

  if (item) {
    m_dontUpdate = true;
    m_enumKeyEdit->setText(item->text(0));
    m_enumNameEdit->setText(item->text(1));

    m_enumKeyEdit->setFocus();
    m_dontUpdate = false;
  }
}

void DatatypeDialog::updateItem()
{
  if (m_dontUpdate)
    return;

  QListViewItem* item = m_enumItemsListView->selectedItem();
  if (item) {
    item->setText(0, m_enumKeyEdit->text());
    item->setText(1, m_enumNameEdit->text());
  }
}

void DatatypeDialog::getBaseType()
{
  Datatype* type = SelectTypeDialog::select(this);
  if (type) {
    m_baseTypeEdit->setText(type->id());
  }
}

#include "datatypedialog.moc"
