/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef COMMANDRUNTIMEDIALOG_H
#define COMMANDRUNTIMEDIALOG_H

// designer includes
#include "commandruntimedialogbase.h"

// forward declarations
namespace WorKflow
{
  class CommandDescription;
}

class CommandRuntimeDialog : public CommandRuntimeDialogBase
{
  Q_OBJECT

public:
  static bool editCommand(QWidget* parent, WorKflow::CommandDescription* desc);

protected:
  CommandRuntimeDialog(QWidget* parent, WorKflow::CommandDescription* desc);
  ~CommandRuntimeDialog();

  void init();

  void initGuiTab();
  void initExecutionTab();
  void initRequirementsTab();
  void initServicesTab();

  QString dcopAppId(const QString& appname);

//   void updateParameterWidgets();
//   void updateResultWidgets();

protected slots:
  virtual void updateService();
  virtual void slotServiceSelectionChanged();
  virtual void removeService();
  virtual void addService();
  virtual void updateRequirement();
  virtual void slotRequirementSelectionChanged();
  virtual void removeRequirement();
  virtual void addRequirement();
  virtual void updateDcopParameter();
  virtual void dcopParameterDown();
  virtual void dcopParameterUp();
  virtual void removeDcopParameter();
  virtual void addDcopParameter();
  virtual void slotDcopParameterSelectionChanged();
  virtual void slotDcopMethodChanged();
  virtual void slotDcopObjectChanged();
  virtual void slotDcopApplicationChanged();
  virtual void updateProgramParameter();
  virtual void slotProgramParameterSelectionChanged();
  virtual void programParameterDown();
  virtual void programParameterUp();
  virtual void removeProgramParameter();
  virtual void addProgramParameter();
  virtual void accept();

  void slotDcopServerChange();

private:
  WorKflow::CommandDescription* m_description;
  bool m_dontUpdate;
};

#endif

