/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// Qt includes
#include <qdom.h>

// WorKflow includes
#include "parameterdescription.h"
#include "commanddescription.h"

using namespace WorKflow;

ParameterDescription::ParameterDescription(CommandDescription* parent)
  : SlotDescription(parent), m_optional(false), m_source(Parameter::AllSources)
{
}

ParameterDescription::~ParameterDescription()
{
  parent()->removeParameterDescription(this);
}

bool ParameterDescription::isOptional() const
{
  return m_optional;
}

Parameter::Source ParameterDescription::source() const
{
  return m_source;
}

void ParameterDescription::setOptional(bool optional)
{
  m_optional = optional;
}

void ParameterDescription::setSource(Parameter::Source source)
{
  m_source = source;
}

void ParameterDescription::readXML(const QDomElement& e)
{
  SlotDescription::readXML(e);

  QString optional = e.attribute("optional");
  if (!optional.isNull()) {
    m_optional = (optional == "true");
  } else {
    m_optional = false;
  }

  QString source = e.attribute("source");
  if (source == "gui")
    m_source = Parameter::GuiSource;
  else if (source == "connection")
    m_source = Parameter::ConnectionSource;
  else
    m_source = Parameter::AllSources;

  // register late, because now we have the ID
  parent()->addParameterDescription(this);
}

void ParameterDescription::writeXML(QDomDocument& doc, QDomElement& e)
{
  QDomElement param = doc.createElement("param");

  SlotDescription::writeXML(doc, param);

  if (m_optional)
    param.setAttribute("optional", "true");

  if (m_source == Parameter::GuiSource)
    param.setAttribute("source", "gui");
  else if (m_source == Parameter::ConnectionSource)
    param.setAttribute("source", "connection");
  else
    param.setAttribute("source", "all");

  e.appendChild(param);
}
