/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// WorKflow includes
#include "commanddrag.h"

using namespace WorKflow;

CommandDrag::CommandDrag(const Info& info, QWidget* dragSource, const char* name)
 : QDragObject(dragSource, name), m_info(info)
{
}


CommandDrag::~CommandDrag()
{
}

const char* CommandDrag::format(int index) const
{
  if (index == 0)
    return "application/x-workflowcommand";
  return 0;
}

QByteArray CommandDrag::encodedData(const char* format) const
{
  QByteArray data;

  if (qstrcmp(format, "application/x-workflowcommand") != 0)
    return data;

  QDataStream out(data, IO_WriteOnly);

  out << static_cast<int>(m_info.kind());
  switch (m_info.kind()) {
    case Info::NewCommand:
      out << m_info.commandId();
      break;
    case Info::ExistingCommand:
      out << m_info.commandId() << m_info.row() << m_info.column();
      break;
    case Info::CopiedCommands:
      out << m_info.copiedCommands();
      break;
  }

  return data;
}

bool CommandDrag::canDecode(const QMimeSource* source)
{
  return source->provides("application/x-workflowcommand");
}

bool CommandDrag::decode(const QMimeSource* source, Info& info)
{
  QByteArray data = source->encodedData("application/x-workflowcommand");
  QDataStream in(data, IO_ReadOnly);

  int kind;
  QString commandId;
  int row;
  int column;
  CommandInfoList commandInfos;

  in >> kind;

  switch (static_cast<Info::Kind>(kind)) {
    case Info::NewCommand:
      in >> commandId;
      info = Info(commandId);
      break;
    case Info::ExistingCommand:
      in >> commandId >> row >> column;
      info = Info(commandId, row, column);
      break;
    case Info::CopiedCommands:
      in >> commandInfos;
      info = Info(commandInfos);
      break;
    default:
      return false;
  }

  return true;
}

#include "commanddrag.moc"
